"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserPermissions = void 0;
var _react = require("react");
var _use_cases_context = require("../cases_context/use_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserPermissions = () => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();

  /**
   * Determines if a user has the capability to update the case. Reopening a case is not part of this capability.
   */

  const canUpdate = permissions.update;

  /**
   * Determines if a user has the capability to change the case from closed => open or closed => in progress
   */

  const canReopenCase = permissions.reopenCase;

  /**
   * Determines if a user has the capability to add comments and attachments
   */
  const getCanAddUserComments = (0, _react.useCallback)(userActivityQueryParams => {
    if (userActivityQueryParams.type === 'action') return false;
    return permissions.createComment;
  }, [permissions.createComment]);
  return {
    getCanAddUserComments,
    canReopenCase,
    canUpdate
  };
};
exports.useUserPermissions = useUserPermissions;