"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservablesUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("./common");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/observables.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getLabel = (actionType, count) => {
  let label = '';
  switch (actionType) {
    case 'add':
      label = (0, _translations.ADDED_OBSERVABLES)(count);
      break;
    case 'delete':
      label = (0, _translations.DELETED_OBSERVABLES)(count);
      break;
    case 'update':
      label = (0, _translations.UPDATED_OBSERVABLES)(count);
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `observables-${actionType}-action`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, label);
};
const createObservablesUserActionBuilder = ({
  userAction,
  userProfiles,
  handleOutlineComment
}) => ({
  build: () => {
    var _action$payload;
    const action = userAction;
    const {
      count,
      actionType
    } = action === null || action === void 0 ? void 0 : (_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.observables;
    const label = getLabel(actionType, count);
    if (count > 0) {
      const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
        userProfiles,
        userAction,
        handleOutlineComment,
        label,
        icon: 'dot'
      });
      return commonBuilder.build();
    }
    return [];
  }
});
exports.createObservablesUserActionBuilder = createObservablesUserActionBuilder;