"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEventAttachmentUserActionBuilder = exports.SingleEventCommentEvent = exports.MultipleEventsCommentEvent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _timestamp = require("../timestamp");
var _hoverable_user_with_avatar_resolver = require("../../user_profiles/hoverable_user_with_avatar_resolver");
var _content_toolbar = require("../content_toolbar");
var _translations = require("./translations");
var i18n = _interopRequireWildcard(require("../translations"));
var _show_event = require("./show_event");
var _event_property_actions = require("../property_actions/event_property_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/comment/event.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getSingleEventUserAction = ({
  userAction,
  userProfiles,
  attachment,
  loadingCommentIds,
  onShowAlertDetails,
  handleDeleteComment
}) => {
  const eventId = getNonEmptyField(attachment.eventId);
  const eventIndex = getNonEmptyField(attachment.index);
  if (!eventId || !eventIndex) {
    return [];
  }
  return [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
      user: userAction.createdBy,
      userProfiles: userProfiles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }),
    eventColor: 'subdued',
    event: /*#__PURE__*/_react.default.createElement(SingleEventCommentEvent, {
      actionId: userAction.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 14
      }
    }),
    'data-test-subj': `user-action-event-${userAction.type}-${userAction.action}-action-${userAction.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: userAction.createdAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 18
      }
    }),
    timelineAvatar: 'bell',
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: attachment.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_show_event.UserActionShowEvent, {
      id: userAction.id,
      eventId: eventId,
      index: eventIndex,
      onShowEventDetails: onShowAlertDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_event_property_actions.EventPropertyActions, {
      onDelete: () => handleDeleteComment(attachment.id, (0, _translations.DELETE_EVENTS_SUCCESS_TITLE)(1)),
      isLoading: loadingCommentIds.includes(attachment.id),
      totalEvents: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }))
  }];
};
const getMultipleEventsUserAction = ({
  userAction,
  userProfiles,
  attachment,
  loadingCommentIds,
  handleDeleteComment
}) => {
  if (!Array.isArray(attachment.eventId)) {
    return [];
  }
  const totalEvents = attachment.eventId.length;
  return [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
      user: userAction.createdBy,
      userProfiles: userProfiles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }),
    eventColor: 'subdued',
    event: /*#__PURE__*/_react.default.createElement(MultipleEventsCommentEvent, {
      actionId: userAction.id,
      totalEvents: totalEvents,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 14
      }
    }),
    'data-test-subj': `user-action-event-${userAction.type}-${userAction.action}-action-${userAction.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: userAction.createdAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 18
      }
    }),
    timelineAvatar: 'bell',
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: attachment.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_event_property_actions.EventPropertyActions, {
      onDelete: () => handleDeleteComment(attachment.id, (0, _translations.DELETE_EVENTS_SUCCESS_TITLE)(totalEvents)),
      isLoading: loadingCommentIds.includes(attachment.id),
      totalEvents: totalEvents,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }))
  }];
};
const createEventAttachmentUserActionBuilder = params => ({
  build: () => {
    const {
      attachment
    } = params;
    const eventId = Array.isArray(attachment.eventId) ? attachment.eventId : [attachment.eventId];
    if (eventId.length === 1) {
      return getSingleEventUserAction(params);
    }
    return getMultipleEventsUserAction(params);
  }
});
exports.createEventAttachmentUserActionBuilder = createEventAttachmentUserActionBuilder;
const getFirstItem = items => {
  return Array.isArray(items) ? items[0] : items !== null && items !== void 0 ? items : null;
};
function getNonEmptyField(field) {
  const firstItem = getFirstItem(field);
  if (firstItem == null || (0, _lodash.isEmpty)(firstItem)) {
    return null;
  }
  return firstItem;
}
const MultipleEventsCommentEventComponent = ({
  actionId,
  totalEvents
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `multiple-events-user-action-${actionId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }, i18n.MULTIPLE_EVENTS_COMMENT_LABEL_TITLE(totalEvents));
};
MultipleEventsCommentEventComponent.displayName = 'MultipleEventsCommentEvent';
const MultipleEventsCommentEvent = exports.MultipleEventsCommentEvent = /*#__PURE__*/(0, _react.memo)(MultipleEventsCommentEventComponent);
const SingleEventCommentEventComponent = ({
  actionId
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `single-event-user-action-${actionId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, i18n.EVENT_COMMENT_LABEL_TITLE);
};
SingleEventCommentEventComponent.displayName = 'SingleEventCommentEvent';
const SingleEventCommentEvent = exports.SingleEventCommentEvent = /*#__PURE__*/(0, _react.memo)(SingleEventCommentEventComponent);