"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplatesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _truncated_text = require("../truncated_text");
var _delete_confirmation_modal = require("../configure_cases/delete_confirmation_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/templates/templates_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplatesListComponent = props => {
  const {
    templates,
    onEditTemplate,
    onDeleteTemplate
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [itemToBeDeleted, setItemToBeDeleted] = (0, _react.useState)(null);
  const onConfirm = (0, _react.useCallback)(() => {
    if (itemToBeDeleted) {
      onDeleteTemplate(itemToBeDeleted.key);
    }
    setItemToBeDeleted(null);
  }, [onDeleteTemplate, setItemToBeDeleted, itemToBeDeleted]);
  const onCancel = (0, _react.useCallback)(() => {
    setItemToBeDeleted(null);
  }, []);
  const showModal = Boolean(itemToBeDeleted);
  return templates.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    "data-test-subj": "templates-list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, templates.map(template => {
    var _template$tags;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: template.key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      "data-test-subj": `template-${template.key}`,
      hasShadow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
      text: template.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 29
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 23
      }
    }, (_template$tags = template.tags) !== null && _template$tags !== void 0 && _template$tags.length ? template.tags.map((tag, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      css: (0, _react2.css)`
                                  max-width: 100px;
                                `,
      key: `${template.key}-tag-${index}`,
      "data-test-subj": `${template.key}-tag-${index}`,
      color: euiTheme.colors.body,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 31
      }
    }, tag)) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexEnd",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${template.key}-template-edit`,
      "aria-label": `${template.key}-template-edit`,
      iconType: "pencil",
      color: "primary",
      onClick: () => onEditTemplate(template.key),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${template.key}-template-delete`,
      "aria-label": `${template.key}-template-delete`,
      iconType: "minusInCircle",
      color: "danger",
      onClick: () => setItemToBeDeleted(template),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 25
      }
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 15
      }
    }));
  })), showModal && itemToBeDeleted ? /*#__PURE__*/_react.default.createElement(_delete_confirmation_modal.DeleteConfirmationModal, {
    title: i18n.DELETE_TITLE(itemToBeDeleted.name),
    message: i18n.DELETE_MESSAGE(itemToBeDeleted.name),
    onCancel: onCancel,
    onConfirm: onConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }) : null)) : null;
};
TemplatesListComponent.displayName = 'TemplatesList';
const TemplatesList = exports.TemplatesList = /*#__PURE__*/_react.default.memo(TemplatesListComponent);