"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  maxLengthField
} = _helpers.fieldValidators;
const schema = exports.schema = {
  key: {
    validations: [{
      validator: emptyField('key')
    }]
  },
  label: {
    label: i18n.OBSERVABLE_TYPE_LABEL,
    validations: [{
      validator: emptyField(i18n.REQUIRED_FIELD(i18n.OBSERVABLE_TYPE_LABEL.toLocaleLowerCase()))
    }, {
      validator: maxLengthField({
        length: _constants.MAX_CUSTOM_OBSERVABLE_TYPES_LABEL_LENGTH,
        message: i18n.MAX_LENGTH_ERROR(i18n.OBSERVABLE_TYPE_LABEL.toLocaleLowerCase(), _constants.MAX_CUSTOM_OBSERVABLE_TYPES_LABEL_LENGTH)
      })
    }]
  }
};