"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMimeType = exports.isValidFileExternalReferenceMetadata = exports.isImage = exports.getFileFromReferenceMetadata = void 0;
var _domain = require("../../../common/types/domain");
var _mime_types = require("../../../common/constants/mime_types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isImage = file => {
  var _file$mimeType;
  return (_file$mimeType = file.mimeType) === null || _file$mimeType === void 0 ? void 0 : _file$mimeType.startsWith('image/');
};
exports.isImage = isImage;
const parseMimeType = mimeType => {
  if (typeof mimeType === 'undefined') {
    return i18n.UNKNOWN_MIME_TYPE;
  }
  if (_mime_types.IMAGE_MIME_TYPES.has(mimeType)) {
    return i18n.IMAGE_MIME_TYPE;
  }
  if (_mime_types.textMimeTypes.includes(mimeType)) {
    return i18n.TEXT_MIME_TYPE;
  }
  if (_mime_types.compressionMimeTypes.includes(mimeType)) {
    return i18n.COMPRESSED_MIME_TYPE;
  }
  if (_mime_types.pdfMimeTypes.includes(mimeType)) {
    return i18n.PDF_MIME_TYPE;
  }
  const result = mimeType.split('/');
  if (result.length <= 1 || result[0] === '') {
    return i18n.UNKNOWN_MIME_TYPE;
  }
  return result[0].charAt(0).toUpperCase() + result[0].slice(1);
};
exports.parseMimeType = parseMimeType;
const isValidFileExternalReferenceMetadata = externalReferenceMetadata => {
  var _externalReferenceMet;
  return _domain.FileAttachmentMetadataRt.is(externalReferenceMetadata) && (externalReferenceMetadata === null || externalReferenceMetadata === void 0 ? void 0 : (_externalReferenceMet = externalReferenceMetadata.files) === null || _externalReferenceMet === void 0 ? void 0 : _externalReferenceMet.length) >= 1;
};
exports.isValidFileExternalReferenceMetadata = isValidFileExternalReferenceMetadata;
const getFileFromReferenceMetadata = ({
  fileId,
  externalReferenceMetadata
}) => {
  const fileMetadata = externalReferenceMetadata.files[0];
  return {
    id: fileId,
    ...fileMetadata
  };
};
exports.getFileFromReferenceMetadata = getFileFromReferenceMetadata;