"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _types = require("../../client/attachment_framework/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/file_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FileAttachmentEvent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_attachment_event'))).then(module => ({
  default: module.FileAttachmentEvent
})));
const FileDeleteButton = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_delete_button'))).then(module => ({
  default: module.FileDeleteButton
})));
const FileDownloadButton = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_download_button'))).then(module => ({
  default: module.FileDownloadButton
})));
const FileThumbnail = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_thumbnail'))).then(module => ({
  default: module.FileThumbnail
})));
function getFileDownloadButton(fileId) {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 25
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FileDownloadButton, {
    fileId: fileId,
    isIcon: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }));
}
function getFileDeleteButton(caseId, fileId) {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 25
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FileDeleteButton, {
    caseId: caseId,
    fileId: fileId,
    isIcon: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
}
const getFileAttachmentActions = ({
  caseId,
  fileId
}) => [{
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getFileDownloadButton(fileId),
  isPrimary: false
}, {
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getFileDeleteButton(caseId, fileId),
  isPrimary: false
}];
const getFileAttachmentViewObject = props => {
  const caseId = props.caseData.id;
  const fileId = props.externalReferenceId;
  if (!(0, _utils.isValidFileExternalReferenceMetadata)(props.externalReferenceMetadata)) {
    return {
      event: i18n.ADDED_UNKNOWN_FILE,
      timelineAvatar: 'document',
      getActions: () => [{
        type: _types.AttachmentActionType.CUSTOM,
        render: () => getFileDeleteButton(caseId, fileId),
        isPrimary: false
      }],
      hideDefaultActions: true
    };
  }
  const file = (0, _utils.getFileFromReferenceMetadata)({
    fileId,
    externalReferenceMetadata: props.externalReferenceMetadata
  });
  return {
    event: /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 27
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FileAttachmentEvent, {
      file: file,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 9
      }
    })),
    timelineAvatar: (0, _utils.isImage)(file) ? 'image' : 'document',
    getActions: () => getFileAttachmentActions({
      caseId,
      fileId
    }),
    hideDefaultActions: true,
    children: (0, _utils.isImage)(file) ? FileThumbnail : undefined
  };
};
const getFileType = () => ({
  id: _constants.FILE_ATTACHMENT_TYPE,
  icon: 'document',
  displayName: 'Files',
  getAttachmentViewObject: getFileAttachmentViewObject,
  getAttachmentRemovalObject: () => ({
    event: i18n.REMOVED_FILE
  })
});
exports.getFileType = getFileType;