"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasePageViewEbt = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../cases_context/use_cases_context");
var _files = require("../../files");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasePageViewEbt = () => {
  const {
    analytics
  } = (0, _kibana.useKibana)().services;
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  (0, _react.useEffect)(() => {
    analytics.reportEvent(_constants.CASE_PAGE_VIEW_EVENT_TYPE, {
      owner: owner[0] && (0, _files.isRegisteredOwner)(owner[0]) ? owner[0] : 'unknown'
    });
  }, [analytics, owner]);
};
exports.useCasePageViewEbt = useCasePageViewEbt;