"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtractObservablesSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../common/translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_settings/extract_observables_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This component is used to toggle the extract observables feature in the case view page.
 */
const ExtractObservablesSwitchComponent = ({
  disabled,
  isEnabled,
  showLabel = false,
  onSwitchChange
}) => {
  const [isOn, setIsOn] = (0, _react.useState)(isEnabled);
  const onChange = (0, _react.useCallback)(() => {
    if (onSwitchChange) {
      onSwitchChange(isOn);
    }
    setIsOn(!isOn);
  }, [isOn, onSwitchChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: isOn ? i18n.EXTRACT_OBSERVABLES_SWITCH_LABEL_ON : i18n.EXTRACT_OBSERVABLES_SWITCH_LABEL_OFF,
    showLabel: showLabel,
    checked: isOn,
    onChange: onChange,
    disabled: disabled,
    "data-test-subj": "extract-observables-switch",
    "aria-label": i18n.EXTRACT_OBSERVABLES_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};
ExtractObservablesSwitchComponent.displayName = 'ExtractObservablesSwitchComponent';
const ExtractObservablesSwitch = exports.ExtractObservablesSwitch = /*#__PURE__*/(0, _react.memo)(ExtractObservablesSwitchComponent);