"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _empty_value = require("../empty_value");
var _user_tooltip = require("../user_profiles/user_tooltip");
var _use_assignees = require("../../containers/user_profiles/use_assignees");
var _data_test_subject = require("../user_profiles/data_test_subject");
var _small_user_avatar = require("../user_profiles/small_user_avatar");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/assignees_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COMPRESSED_AVATAR_LIMIT = 3;
const AssigneesColumnComponent = ({
  assignees,
  userProfiles,
  compressedDisplayLimit = COMPRESSED_AVATAR_LIMIT
}) => {
  const [isAvatarListExpanded, setIsAvatarListExpanded] = (0, _react.useState)(false);
  const {
    allAssignees
  } = (0, _use_assignees.useAssignees)({
    caseAssignees: assignees,
    userProfiles
  });
  const toggleExpandedAvatars = (0, _react.useCallback)(() => setIsAvatarListExpanded(prevState => !prevState), []);
  const numHiddenAvatars = allAssignees.length - compressedDisplayLimit;
  const shouldShowExpandListButton = numHiddenAvatars > 0;
  const limitedAvatars = (0, _react.useMemo)(() => allAssignees.slice(0, compressedDisplayLimit), [allAssignees, compressedDisplayLimit]);
  const avatarsToDisplay = (0, _react.useMemo)(() => {
    if (isAvatarListExpanded || !shouldShowExpandListButton) {
      return allAssignees;
    }
    return limitedAvatars;
  }, [allAssignees, isAvatarListExpanded, limitedAvatars, shouldShowExpandListButton]);
  if (allAssignees.length <= 0) {
    return (0, _empty_value.getEmptyCellValue)();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": "case-table-column-assignee",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, avatarsToDisplay.map(assignee => {
    const dataTestSubjName = (0, _data_test_subject.getUsernameDataTestSubj)(assignee);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: assignee.uid,
      "data-test-subj": `case-table-column-assignee-${dataTestSubjName}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
      userInfo: assignee.profile,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_small_user_avatar.SmallUserAvatar, {
      userInfo: assignee.profile,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    })));
  }), shouldShowExpandListButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "case-table-column-expand-button",
    onClick: toggleExpandedAvatars,
    style: {
      alignSelf: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, isAvatarListExpanded ? i18n.SHOW_LESS : i18n.SHOW_MORE(numHiddenAvatars)) : null);
};
AssigneesColumnComponent.displayName = 'AssigneesColumn';
const AssigneesColumn = exports.AssigneesColumn = /*#__PURE__*/_react.default.memo(AssigneesColumnComponent);