"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnalytics = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAnalytics = ({
  analyticsService
}) => {
  analyticsService.registerEventType({
    eventType: _constants.CASE_PAGE_VIEW_EVENT_TYPE,
    schema: {
      owner: {
        type: 'keyword',
        _meta: {
          description: 'The solution ID (owner) that rendered the Cases page',
          optional: false
        }
      }
    }
  });
};
exports.registerAnalytics = registerAnalytics;