"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAssets = exports.setAssetValue = exports.setAsset = exports.resetAssets = exports.removeAsset = void 0;
var _reduxActions = require("redux-actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setAssetValue = exports.setAssetValue = (0, _reduxActions.createAction)('setAssetContent', (id, value) => ({
  id,
  value
}));
const setAsset = exports.setAsset = (0, _reduxActions.createAction)('setAsset', asset => ({
  asset
}));
const removeAsset = exports.removeAsset = (0, _reduxActions.createAction)('removeAsset');
const setAssets = exports.setAssets = (0, _reduxActions.createAction)('setAssets');
const resetAssets = exports.resetAssets = (0, _reduxActions.createAction)('resetAssets');