"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCanvasExpressionService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _interpreter = require("@kbn/interpreter");
var _rxjs = require("rxjs");
var _build_embeddable_filters = require("../../common/lib/build_embeddable_filters");
var _kibana_services = require("./kibana_services");
var _canvas_notify_service = require("./canvas_notify_service");
var _canvas_filters_service = require("./canvas_filters_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExpressionsService {
  constructor() {
    (0, _defineProperty2.default)(this, "notifyService", void 0);
    (0, _defineProperty2.default)(this, "filtersService", void 0);
    this.notifyService = (0, _canvas_notify_service.getCanvasNotifyService)();
    this.filtersService = (0, _canvas_filters_service.getCanvasFiltersService)();
  }
  async interpretAst(ast, variables, input = null) {
    const context = await this.getGlobalContext();
    return await this.interpretAstWithContext(ast, input, {
      ...(context !== null && context !== void 0 ? context : {}),
      variables
    });
  }
  async interpretAstWithContext(ast, input = null, context) {
    return await _kibana_services.expressionsService.execute(ast, input, {
      ...context,
      namespace: 'canvas'
    }).getData().pipe((0, _rxjs.pluck)('result')).toPromise();
  }

  /**
   * Runs interpreter, usually in the browser
   *
   * @param {object} ast - Executable AST
   * @param {any} input - Initial input for AST execution
   * @param {object} variables - Variables to pass in to the intrepreter context
   * @param {object} options
   * @param {boolean} options.castToRender - try to cast to a type: render object?
   * @returns {Promise<ExpressionValue>}
   */
  async runInterpreter(ast, input, variables, options = {}) {
    const context = await this.getGlobalContext();
    const fullContext = {
      ...(context !== null && context !== void 0 ? context : {}),
      variables
    };
    try {
      const renderable = await this.interpretAstWithContext(ast, input, fullContext);
      if ((0, _interpreter.getType)(renderable) === 'render') {
        return renderable;
      }
      if (options.castToRender) {
        return this.runInterpreter((0, _interpreter.fromExpression)('render'), renderable, fullContext, {
          castToRender: false
        });
      }
      throw new Error(`Ack! I don't know how to render a '${(0, _interpreter.getType)(renderable)}'`);
    } catch (err) {
      this.notifyService.error(err);
      throw err;
    }
  }
  getRenderer(name) {
    return _kibana_services.expressionsService.getRenderer(name);
  }
  getFunctions() {
    return _kibana_services.expressionsService.getFunctions();
  }
  async getFilters() {
    const filtersList = this.filtersService.getFilters();
    const context = this.filtersService.getFiltersContext();
    const filterExpression = filtersList.join(' | ');
    const filterAST = (0, _interpreter.fromExpression)(filterExpression);
    return await this.interpretAstWithContext(filterAST, null, context);
  }
  async getGlobalContext() {
    const canvasFilters = await this.getFilters();
    const kibanaFilters = (0, _build_embeddable_filters.buildEmbeddableFilters)(canvasFilters ? canvasFilters.and : []);
    return {
      searchContext: {
        ...kibanaFilters
      }
    };
  }
}
let canvasExpressionsService;
const getCanvasExpressionService = () => {
  if (!canvasExpressionsService) {
    canvasExpressionsService = new ExpressionsService();
  }
  return canvasExpressionsService;
};
exports.getCanvasExpressionService = getCanvasExpressionService;