"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadPresentationHelper = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _breadcrumbs = require("../../lib/breadcrumbs");
var _doc_title = require("../../lib/doc_title");
var _workpad = require("../../state/selectors/workpad");
var _use_fullscreen_presentation_helper = require("./hooks/use_fullscreen_presentation_helper");
var _use_autoplay_helper = require("./hooks/use_autoplay_helper");
var _use_refresh_helper = require("./hooks/use_refresh_helper");
var _kibana_services = require("../../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWorkpadLabel = () => _i18n.i18n.translate('xpack.canvas.workpadConflict.redirectLabel', {
  defaultMessage: 'Workpad'
});
const WorkpadPresentationHelper = ({
  children
}) => {
  const workpad = (0, _reactRedux.useSelector)(_workpad.getWorkpad);
  (0, _use_fullscreen_presentation_helper.useFullscreenPresentationHelper)();
  (0, _use_autoplay_helper.useAutoplayHelper)();
  (0, _use_refresh_helper.useRefreshHelper)();
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    _kibana_services.coreServices.chrome.setBreadcrumbs([(0, _breadcrumbs.getBaseBreadcrumb)(history), (0, _breadcrumbs.getWorkpadBreadcrumb)({
      name: workpad.name
    })]);
  }, [workpad.name, history]);
  (0, _react.useEffect)(() => {
    (0, _doc_title.setDocTitle)(workpad.name || (0, _doc_title.getUntitledWorkpadLabel)());
  }, [workpad.name, workpad.id]);
  const conflictElement = workpad.aliasId ? _kibana_services.spacesService === null || _kibana_services.spacesService === void 0 ? void 0 : _kibana_services.spacesService.ui.components.getLegacyUrlConflict({
    objectNoun: getWorkpadLabel(),
    currentObjectId: workpad.id,
    otherObjectId: workpad.aliasId,
    otherObjectPath: `/workpad/${workpad.aliasId}`
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, conflictElement, children);
};
exports.WorkpadPresentationHelper = WorkpadPresentationHelper;