"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageSync = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _workpad = require("../../../state/selectors/workpad");
var _pages = require("../../../state/actions/pages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const usePageSync = () => {
  const params = (0, _reactRouterDom.useParams)();
  const workpad = (0, _reactRedux.useSelector)(_workpad.getWorkpad);
  const dispatch = (0, _reactRedux.useDispatch)();
  const pageNumber = parseInt(params.pageNumber, 10);
  let pageIndex = workpad.page;
  if (!isNaN(pageNumber)) {
    pageIndex = pageNumber - 1;
  }
  (0, _react.useEffect)(() => {
    if (pageIndex !== workpad.page) {
      dispatch((0, _pages.setPage)(pageIndex));
    }
  }, [pageIndex, workpad.page, dispatch]);
};
exports.usePageSync = usePageSync;