"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _workpad_color_picker = require("../workpad_color_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/page_config/page_config.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getBackgroundColorDescription: () => _i18n.i18n.translate('xpack.canvas.pageConfig.backgroundColorDescription', {
    defaultMessage: 'Accepts HEX, RGB or HTML color names'
  }),
  getBackgroundColorLabel: () => _i18n.i18n.translate('xpack.canvas.pageConfig.backgroundColorLabel', {
    defaultMessage: 'Background'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.pageConfig.title', {
    defaultMessage: 'Page settings'
  }),
  getTransitionLabel: () => _i18n.i18n.translate('xpack.canvas.pageConfig.transitionLabel', {
    defaultMessage: 'Transition',
    description: 'This refers to the transition effect, such as fade in or rotate,  applied to a page in presentation mode.'
  }),
  getTransitionPreviewLabel: () => _i18n.i18n.translate('xpack.canvas.pageConfig.transitionPreviewLabel', {
    defaultMessage: 'Preview',
    description: 'This is the label for a preview of the transition effect selected.'
  })
};
const PageConfig = ({
  pageIndex,
  setBackground,
  background,
  transition,
  transitions,
  setTransition
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    className: "canvasSidebar__panelTitleHeading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, strings.getTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: strings.getBackgroundColorDescription(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }, strings.getBackgroundColorLabel(), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 51
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_workpad_color_picker.WorkpadColorPicker, {
    onChange: setBackground,
    value: background,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })), pageIndex > 0 ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getTransitionLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: transition ? transition.name : '',
    options: transitions,
    compressed: true,
    onChange: e => setTransition(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  })), transition ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getTransitionPreviewLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: "",
    description: "",
    className: transition.enter,
    style: {
      height: '72px',
      width: '128px',
      background,
      animationDuration: '1s'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  })) : '') : '');
};
exports.PageConfig = PageConfig;
PageConfig.propTypes = {
  pageIndex: _propTypes.default.number.isRequired,
  background: _propTypes.default.string,
  setBackground: _propTypes.default.func.isRequired,
  transition: _propTypes.default.shape({
    name: _propTypes.default.string
  }),
  transitions: _propTypes.default.arrayOf(_propTypes.default.shape({
    text: _propTypes.default.string.isRequired,
    value: _propTypes.default.string.isRequired
  })).isRequired,
  setTransition: _propTypes.default.func.isRequired
};