"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _app = require("../../../state/selectors/app");
var _hooks = require("../../hooks");
var _hooks2 = require("../hooks");
var _kibana_services = require("../../../services/kibana_services");
var _my_workpads = require("./my_workpads");
var _workpad_table = require("./workpad_table.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/my_workpads/workpad_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadTable = () => {
  const onCloneWorkpad = (0, _hooks2.useCloneWorkpad)();
  const onExportWorkpad = (0, _hooks.useDownloadWorkpad)();
  const context = (0, _react.useContext)(_my_workpads.WorkpadsContext);
  const {
    canUserWrite
  } = (0, _reactRedux.useSelector)(state => ({
    canUserWrite: (0, _app.canUserWrite)(state)
  }));
  if (!context) {
    return null;
  }
  const {
    workpads
  } = context;
  const dateFormat = _kibana_services.coreServices.uiSettings.get('dateFormat');
  return /*#__PURE__*/_react.default.createElement(_workpad_table.WorkpadTable, {
    workpads,
    dateFormat,
    canUserWrite,
    onCloneWorkpad,
    onExportWorkpad,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 10
    }
  });
};
exports.WorkpadTable = WorkpadTable;