"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadDropzone = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../../../i18n");
var _hooks = require("../hooks");
var _upload_dropzone = require("./upload_dropzone.component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/my_workpads/upload_dropzone.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  WorkpadDropzone: errors
} = _i18n.ErrorStrings;
const UploadDropzone = ({
  children
}) => {
  const notify = (0, _services.useNotifyService)();
  const uploadWorkpad = (0, _hooks.useImportWorkpad)();
  const [isDisabled, setIsDisabled] = (0, _react.useState)(false);
  const onDrop = files => {
    if (!files) {
      return;
    }
    if (files.length > 1) {
      notify.warning(errors.getTooManyFilesErrorMessage());
      return;
    }
    setIsDisabled(true);
    uploadWorkpad(files[0], () => setIsDisabled(false));
  };
  return /*#__PURE__*/_react.default.createElement(_upload_dropzone.UploadDropzone, {
    disabled: isDisabled,
    onDrop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, children);
};
exports.UploadDropzone = UploadDropzone;