"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PendingArgValue = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _loading = require("../loading");
var _arg_label = require("./arg_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/pending_arg_value.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getLoadingMessage: () => _i18n.i18n.translate('xpack.canvas.argFormPendingArgValue.loadingMessage', {
    defaultMessage: 'Loading'
  })
};
class PendingArgValue extends _react.default.PureComponent {
  componentDidMount() {
    // on mount, resolve the arg value using the argResolver
    const {
      setResolvedArgValue,
      templateProps
    } = this.props;
    const {
      argResolver,
      argValue
    } = templateProps;
    if (argValue == null) {
      setResolvedArgValue(null);
    } else {
      argResolver(argValue).then(val => setResolvedArgValue(val != null ? val : null)).catch(() => setResolvedArgValue(null)); // swallow error, it's not important
    }
  }
  render() {
    const {
      label,
      argTypeInstance
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasArg",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_arg_label.ArgLabel, {
      className: "resolve-pending",
      label: label,
      help: argTypeInstance.help,
      expandable: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasArg--pending",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      animated: true,
      text: strings.getLoadingMessage(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }))));
  }
}
exports.PendingArgValue = PendingArgValue;
(0, _defineProperty2.default)(PendingArgValue, "propTypes", {
  label: _propTypes.default.string,
  argTypeInstance: _propTypes.default.shape({
    help: _propTypes.default.string.isRequired
  }).isRequired,
  setResolvedArgValue: _propTypes.default.func.isRequired,
  templateProps: _propTypes.default.shape({
    argResolver: _propTypes.default.func.isRequired,
    argValue: _propTypes.default.any
  })
});