"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Telemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("./events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service that interacts with the Core's analytics module
 */
class Telemetry {
  constructor() {
    (0, _defineProperty2.default)(this, "analytics", void 0);
  }
  setup(analytics) {
    this.analytics = analytics;
    Object.entries(_events.telemetryEventsSchemas).forEach(([eventType, schema]) => {
      const event = {
        eventType,
        schema
      };
      analytics.registerEventType(event);
    });
  }
  start() {
    var _this$analytics;
    const reportEvent = (_this$analytics = this.analytics) === null || _this$analytics === void 0 ? void 0 : _this$analytics.reportEvent.bind(this.analytics);
    if (!reportEvent) {
      throw new Error('The Telemetry.setup() method has not been invoked, be sure to call it during the plugin setup.');
    }
    return {
      reportEvent
    };
  }
}
exports.Telemetry = Telemetry;