"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPLOAD_SPEC_TITLE = exports.SAVE_CONFIG = exports.RETRY = exports.OPEN_API_SPEC_TITLE = exports.GENERATE_BUTTON_HINT = exports.CONFIRM_SETTINGS_TITLE = exports.CANCEL = exports.ANALYZE_BUTTON_HINT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * flyout container
 */
const OPEN_API_SPEC_TITLE = exports.OPEN_API_SPEC_TITLE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.createCel.openApiSpecTitle', {
  defaultMessage: 'OpenAPI spec'
});
const UPLOAD_SPEC_TITLE = exports.UPLOAD_SPEC_TITLE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.createCel.uploadSpecTitle', {
  defaultMessage: 'Upload OpenAPI Specification'
});
const CONFIRM_SETTINGS_TITLE = exports.CONFIRM_SETTINGS_TITLE = _i18n.i18n.translate('xpack.automaticImport.celFlyout.createCel.confirmSettingsTitle', {
  defaultMessage: 'Choose API endpoint and Authentication method'
});

/**
 * footer
 */
const SAVE_CONFIG = exports.SAVE_CONFIG = _i18n.i18n.translate('xpack.automaticImport.celFlyout.footer.saveAndContinue', {
  defaultMessage: 'Save Configuration'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.automaticImport.celFlyout.footer.cancel', {
  defaultMessage: 'Cancel'
});
const ANALYZE_BUTTON_HINT = exports.ANALYZE_BUTTON_HINT = _i18n.i18n.translate('xpack.automaticImport.celFlyout.footer.analyzeHint', {
  defaultMessage: 'Analyze your OpenAPI spec file before saving'
});
const GENERATE_BUTTON_HINT = exports.GENERATE_BUTTON_HINT = _i18n.i18n.translate('xpack.automaticImport.celFlyout.footer.generateHint', {
  defaultMessage: 'Generate your CEL input configuration before saving'
});

/**
 * generation error
 */
const RETRY = exports.RETRY = _i18n.i18n.translate('xpack.automaticImport.celFlyout.retry', {
  defaultMessage: 'Retry'
});