"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SamplesFormatNameEnum = exports.SamplesFormatName = exports.SamplesFormat = exports.RawSamples = exports.Pipeline = exports.PackageTitle = exports.PackageName = exports.Mapping = exports.LogSamples = exports.LangSmithOptions = exports.Integration = exports.InputTypeEnum = exports.InputType = exports.Docs = exports.DataStreamTitle = exports.DataStreamName = exports.DataStream = exports.Connector = void 0;
var _zod = require("@kbn/zod");
var _processor_attributes = require("./processor_attributes.gen");
var _cel_input_attributes = require("./cel_input_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Rule Attributes
 *   version: not applicable
 */

/**
 * Package name for the integration to be built.
 */

const PackageName = exports.PackageName = _zod.z.string().min(1);

/**
 * DataStream name for the integration to be built.
 */

const DataStreamName = exports.DataStreamName = _zod.z.string().min(1);

/**
 * Package title for the integration to be built.
 */

const PackageTitle = exports.PackageTitle = _zod.z.string().min(1);

/**
 * DataStream title for the integration to be built.
 */

const DataStreamTitle = exports.DataStreamTitle = _zod.z.string().min(1);

/**
 * String form of the input logsamples.
 */

const LogSamples = exports.LogSamples = _zod.z.array(_zod.z.string());

/**
 * String array containing the json raw samples that are used for ecs mapping.
 */

const RawSamples = exports.RawSamples = _zod.z.array(_zod.z.string());

/**
 * mapping object to ECS Mapping Request.
 */

const Mapping = exports.Mapping = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * LLM Connector to be used in each API request.
 */

const Connector = exports.Connector = _zod.z.string();

/**
 * An array of processed documents.
 */

const Docs = exports.Docs = _zod.z.array(_zod.z.object({}).catchall(_zod.z.unknown()));

/**
 * The name of the log samples format.
 */

const SamplesFormatName = exports.SamplesFormatName = _zod.z.enum(['ndjson', 'json', 'csv', 'structured', 'unstructured', 'unsupported', 'cef', 'leef', 'fix']);
const SamplesFormatNameEnum = exports.SamplesFormatNameEnum = SamplesFormatName.enum;

/**
 * Format of the provided log samples.
 */

const SamplesFormat = exports.SamplesFormat = _zod.z.object({
  name: SamplesFormatName,
  /**
   * For some formats, specifies whether the samples can be multiline.
   */
  multiline: _zod.z.boolean().optional(),
  /**
   * For CSV format, specifies whether the samples have a header row. For other formats, specifies the presence of header in each row.
   */
  header: _zod.z.boolean().optional(),
  /**
   * For CSV format, specifies the column names proposed by the LLM.
   */
  columns: _zod.z.array(_zod.z.string()).optional(),
  /**
   * For a JSON format, describes how to get to the sample array from the root of the JSON.
   */
  json_path: _zod.z.array(_zod.z.string()).optional()
});

/**
 * The pipeline object.
 */

const Pipeline = exports.Pipeline = _zod.z.object({
  /**
   * The name of the pipeline.
   */
  name: _zod.z.string().optional(),
  /**
   * The description of the pipeline.
   */
  description: _zod.z.string().optional(),
  /**
   * The version of the pipeline.
   */
  version: _zod.z.number().int().optional(),
  /**
   * The processors to execute.
   */
  processors: _zod.z.array(_processor_attributes.ESProcessorItem),
  /**
   * The processors to execute if the pipeline fails.
   */
  on_failure: _zod.z.array(_processor_attributes.ESProcessorItem).optional()
});

/**
 * The input type for the dataStream to pull logs from.
 */

const InputType = exports.InputType = _zod.z.enum(['aws-cloudwatch', 'aws-s3', 'azure-blob-storage', 'azure-eventhub', 'cel', 'cloudfoundry', 'filestream', 'gcp-pubsub', 'gcs', 'http_endpoint', 'journald', 'kafka', 'tcp', 'udp']);
const InputTypeEnum = exports.InputTypeEnum = InputType.enum;

/**
 * The dataStream object.
 */

const DataStream = exports.DataStream = _zod.z.object({
  /**
   * The name of the dataStream.
   */
  name: _zod.z.string(),
  /**
   * The title of the dataStream.
   */
  title: _zod.z.string(),
  /**
   * The description of the dataStream.
   */
  description: _zod.z.string(),
  /**
   * The input types of the dataStream.
   */
  inputTypes: _zod.z.array(InputType),
  /**
   * The raw samples of the dataStream.
   */
  rawSamples: RawSamples,
  /**
   * The pipeline of the dataStream.
   */
  pipeline: Pipeline,
  /**
   * The documents of the dataStream.
   */
  docs: Docs,
  /**
   * The format of log samples in this dataStream.
   */
  samplesFormat: SamplesFormat,
  /**
   * The optional CEL input configuration for the dataStream.
   */
  celInput: _cel_input_attributes.CelInput.optional()
});

/**
 * The integration object.
 */

const Integration = exports.Integration = _zod.z.object({
  /**
   * The name of the integration.
   */
  name: _zod.z.string(),
  /**
   * The title of the integration.
   */
  title: _zod.z.string(),
  /**
   * The description of the integration.
   */
  description: _zod.z.string(),
  /**
   * The dataStreams of the integration.
   */
  dataStreams: _zod.z.array(DataStream),
  /**
   * The logo of the integration.
   */
  logo: _zod.z.string().optional()
});

/**
 * The LangSmith options object.
 */

const LangSmithOptions = exports.LangSmithOptions = _zod.z.object({
  /**
   * The project name.
   */
  projectName: _zod.z.string(),
  /**
   * The apiKey to use for tracing.
   */
  apiKey: _zod.z.string()
});