"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apmCustomDashboards = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _custom_dashboards = require("../../common/custom_dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmCustomDashboards = exports.apmCustomDashboards = {
  name: _custom_dashboards.APM_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE,
  hidden: false,
  namespaceType: 'multiple',
  mappings: {
    properties: {
      dashboardSavedObjectId: {
        type: 'keyword'
      },
      kuery: {
        type: 'text'
      },
      serviceEnvironmentFilterEnabled: {
        type: 'boolean'
      },
      serviceNameFilterEnabled: {
        type: 'boolean'
      }
    }
  },
  management: {
    importableAndExportable: true,
    icon: 'apmApp',
    getTitle: () => _i18n.i18n.translate('xpack.apm.apmServiceDashboards.title', {
      defaultMessage: 'APM Service Custom Dashboards'
    })
  },
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        create: _configSchema.schema.object({
          dashboardSavedObjectId: _configSchema.schema.string(),
          kuery: _configSchema.schema.maybe(_configSchema.schema.string()),
          serviceEnvironmentFilterEnabled: _configSchema.schema.boolean(),
          serviceNameFilterEnabled: _configSchema.schema.boolean()
        })
      }
    }
  }
};