"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.traceRouteRepository = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _trace_explorer = require("../../../common/trace_explorer");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_random_sampler = require("../../lib/helpers/get_random_sampler");
var _transactions = require("../../lib/helpers/transactions");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_span = require("../transactions/get_span");
var _get_transaction = require("../transactions/get_transaction");
var _get_transaction_by_name = require("../transactions/get_transaction_by_name");
var _get_transaction_by_trace = require("../transactions/get_transaction_by_trace");
var _build_focused_trace_items = require("./build_focused_trace_items");
var _get_top_traces_primary_stats = require("./get_top_traces_primary_stats");
var _get_trace_items = require("./get_trace_items");
var _get_trace_samples_by_query = require("./get_trace_samples_by_query");
var _get_trace_summary_count = require("./get_trace_summary_count");
var _get_unified_trace_items = require("./get_unified_trace_items");
var _get_unified_trace_errors = require("./get_unified_trace_errors");
var _create_logs_client = require("../../lib/helpers/create_es_client/create_logs_client");
var _normalize_errors = require("./normalize_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tracesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/traces',
  params: t.type({
    query: t.intersection([_default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, _default_api_types.probabilityRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      config,
      params,
      request,
      core
    } = resources;
    const {
      environment,
      kuery,
      start,
      end,
      probability
    } = params.query;
    const coreStart = await core.start();
    const [apmEventClient, randomSampler] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _get_random_sampler.getRandomSampler)({
      coreStart,
      request,
      probability
    })]);
    const searchAggregatedTransactions = await (0, _transactions.getSearchTransactionsEvents)({
      apmEventClient,
      config,
      kuery,
      start,
      end
    });
    return await (0, _get_top_traces_primary_stats.getTopTracesPrimaryStats)({
      environment,
      kuery,
      apmEventClient,
      searchAggregatedTransactions,
      start,
      end,
      randomSampler
    });
  }
});
const tracesByIdRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/traces/{traceId}',
  params: t.type({
    path: t.type({
      traceId: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, t.type({
      entryTransactionId: t.string
    }), t.partial({
      maxTraceItems: _ioTsUtils.toNumberRt
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      params,
      config,
      logger
    } = resources;
    const {
      traceId
    } = params.path;
    const {
      start,
      end,
      entryTransactionId
    } = params.query;
    const [traceItems, entryTransaction] = await Promise.all([(0, _get_trace_items.getTraceItems)({
      traceId,
      config,
      apmEventClient,
      start,
      end,
      maxTraceItemsFromUrlParam: params.query.maxTraceItems,
      logger
    }), (0, _get_transaction.getTransaction)({
      transactionId: entryTransactionId,
      traceId,
      apmEventClient,
      start,
      end
    })]);
    return {
      traceItems,
      entryTransaction
    };
  }
});
const unifiedTracesByIdRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/unified_traces/{traceId}',
  params: t.type({
    path: t.type({
      traceId: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, t.partial({
      maxTraceItems: _ioTsUtils.toNumberRt
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const [apmEventClient, logsClient] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _create_logs_client.createLogsClient)(resources)]);
    const {
      params,
      config
    } = resources;
    const {
      traceId
    } = params.path;
    const {
      start,
      end
    } = params.query;
    const {
      traceItems
    } = await (0, _get_unified_trace_items.getUnifiedTraceItems)({
      apmEventClient,
      logsClient,
      traceId,
      start,
      end,
      maxTraceItemsFromUrlParam: params.query.maxTraceItems,
      config
    });
    return {
      traceItems
    };
  }
});
const unifiedTracesByIdSummaryRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/unified_traces/{traceId}/summary',
  params: t.type({
    path: t.type({
      traceId: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, t.partial({
      maxTraceItems: _ioTsUtils.toNumberRt,
      docId: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    var _findRootItem;
    const [apmEventClient, logsClient] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _create_logs_client.createLogsClient)(resources)]);
    const {
      params,
      config
    } = resources;
    const {
      traceId
    } = params.path;
    const {
      start,
      end,
      docId
    } = params.query;
    const [{
      traceItems,
      unifiedTraceErrors
    }, traceSummaryCount] = await Promise.all([(0, _get_unified_trace_items.getUnifiedTraceItems)({
      apmEventClient,
      logsClient,
      traceId,
      start,
      end,
      maxTraceItemsFromUrlParam: params.query.maxTraceItems,
      config
    }), (0, _get_trace_summary_count.getTraceSummaryCount)({
      apmEventClient,
      start,
      end,
      traceId
    })]);
    const focusedDocId = docId !== null && docId !== void 0 ? docId : (_findRootItem = (0, _build_focused_trace_items.findRootItem)(traceItems)) === null || _findRootItem === void 0 ? void 0 : _findRootItem.id;
    const focusedTraceItems = focusedDocId ? (0, _build_focused_trace_items.buildFocusedTraceItems)({
      traceItems,
      docId: focusedDocId
    }) : undefined;
    return {
      traceItems: focusedTraceItems,
      summary: {
        ...traceSummaryCount,
        errors: unifiedTraceErrors.totalErrors
      }
    };
  }
});
const unifiedTracesByIdErrorsRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/unified_traces/{traceId}/errors',
  params: t.type({
    path: t.type({
      traceId: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, t.partial({
      docId: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const [apmEventClient, logsClient] = await Promise.all([(0, _get_apm_event_client.getApmEventClient)(resources), (0, _create_logs_client.createLogsClient)(resources)]);
    const {
      params
    } = resources;
    const {
      traceId
    } = params.path;
    const {
      start,
      end,
      docId
    } = params.query;
    const {
      apmErrors,
      unprocessedOtelErrors
    } = await (0, _get_unified_trace_errors.getUnifiedTraceErrors)({
      apmEventClient,
      logsClient,
      docId,
      traceId,
      start,
      end
    });
    if (apmErrors.length > 0) {
      return {
        traceErrors: (0, _normalize_errors.normalizeErrors)(apmErrors),
        source: 'apm'
      };
    }
    return {
      traceErrors: (0, _normalize_errors.normalizeErrors)(unprocessedOtelErrors),
      source: 'unprocessedOtel'
    };
  }
});
const rootTransactionByTraceIdRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/traces/{traceId}/root_transaction',
  params: t.type({
    path: t.type({
      traceId: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params: {
        path: {
          traceId
        },
        query: {
          start,
          end
        }
      }
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return (0, _get_transaction_by_trace.getRootTransactionByTraceId)({
      traceId,
      apmEventClient,
      start,
      end
    });
  }
});
const transactionByIdRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/transactions/{transactionId}',
  params: t.type({
    path: t.type({
      transactionId: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params: {
        path: {
          transactionId
        },
        query: {
          start,
          end
        }
      }
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return {
      transaction: await (0, _get_transaction.getTransaction)({
        transactionId,
        apmEventClient,
        start,
        end
      })
    };
  }
});
const transactionByNameRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/transactions',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, t.type({
      transactionName: t.string,
      serviceName: t.string
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params: {
        query: {
          start,
          end,
          transactionName,
          serviceName
        }
      }
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return {
      transaction: await (0, _get_transaction_by_name.getTransactionByName)({
        transactionName,
        apmEventClient,
        start,
        end,
        serviceName
      })
    };
  }
});
const findTracesRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/traces/find',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.environmentRt, t.type({
      query: t.string,
      type: t.union([t.literal(_trace_explorer.TraceSearchType.kql), t.literal(_trace_explorer.TraceSearchType.eql)])
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      start,
      end,
      environment,
      query,
      type
    } = resources.params.query;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return {
      traceSamples: await (0, _get_trace_samples_by_query.getTraceSamplesByQuery)({
        apmEventClient,
        start,
        end,
        environment,
        query,
        type
      })
    };
  }
});
const transactionFromTraceByIdRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/traces/{traceId}/transactions/{transactionId}',
  params: t.type({
    path: t.type({
      traceId: t.string,
      transactionId: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const {
      path: {
        transactionId,
        traceId
      },
      query: {
        start,
        end
      }
    } = params;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return await (0, _get_transaction.getTransaction)({
      transactionId,
      traceId,
      apmEventClient,
      start,
      end
    });
  }
});
const spanFromTraceByIdRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/traces/{traceId}/spans/{spanId}',
  params: t.type({
    path: t.type({
      traceId: t.string,
      spanId: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, t.union([t.partial({
      parentTransactionId: t.string
    }), t.undefined])])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const {
      params
    } = resources;
    const {
      path: {
        spanId,
        traceId
      },
      query: {
        start,
        end,
        parentTransactionId
      }
    } = params;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    return await (0, _get_span.getSpan)({
      spanId,
      parentTransactionId,
      traceId,
      apmEventClient,
      start,
      end
    });
  }
});
const traceRouteRepository = exports.traceRouteRepository = {
  ...tracesByIdRoute,
  ...unifiedTracesByIdRoute,
  ...tracesRoute,
  ...rootTransactionByTraceIdRoute,
  ...transactionByIdRoute,
  ...findTracesRoute,
  ...transactionFromTraceByIdRoute,
  ...spanFromTraceByIdRoute,
  ...transactionByNameRoute,
  ...unifiedTracesByIdSummaryRoute,
  ...unifiedTracesByIdErrorsRoute
};