"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceInstanceMetadataDetails = getServiceInstanceMetadataDetails;
var _lodash = require("lodash");
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _apm = require("../../../common/es_fields/apm");
var _maybe4 = require("../../../common/utils/maybe");
var _transactions = require("../../lib/helpers/transactions");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _service_metadata = require("../../../common/service_metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceInstanceMetadataDetails({
  serviceName,
  serviceNodeName,
  apmEventClient,
  start,
  end
}) {
  const filter = [{
    term: {
      [_apm.SERVICE_NAME]: serviceName
    }
  }, {
    term: {
      [_apm.SERVICE_NODE_NAME]: serviceNodeName
    }
  }, ...(0, _server.rangeQuery)(start, end)];
  const requiredKeys = (0, _as_mutable_array.asMutableArray)([_apm.AT_TIMESTAMP, _apm.SERVICE_NAME, _apm.AGENT_NAME]);
  const optionalKeys = (0, _as_mutable_array.asMutableArray)([_apm.SERVICE_ENVIRONMENT, ..._service_metadata.SERVICE_METADATA_SERVICE_KEYS, ..._service_metadata.SERVICE_METADATA_CLOUD_KEYS, ..._service_metadata.SERVICE_METADATA_CONTAINER_KEYS, ..._service_metadata.SERVICE_METADATA_INFRA_METRICS_KEYS]);
  const fields = [...requiredKeys, ...optionalKeys];
  async function getApplicationMetricSample() {
    var _maybe;
    const response = await apmEventClient.search('get_service_instance_metadata_details_application_metric', {
      apm: {
        events: [_common.ProcessorEvent.metric]
      },
      track_total_hits: false,
      terminate_after: 1,
      size: 1,
      query: {
        bool: {
          filter: filter.concat({
            term: {
              [_apm.METRICSET_NAME]: 'app'
            }
          })
        }
      },
      fields
    });
    return (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe4.maybe)(response.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields, requiredKeys);
  }
  async function getTransactionEventSample() {
    var _maybe2;
    const response = await apmEventClient.search('get_service_instance_metadata_details_application_transaction_event', {
      apm: {
        events: [_common.ProcessorEvent.transaction]
      },
      track_total_hits: false,
      terminate_after: 1,
      size: 1,
      query: {
        bool: {
          filter
        }
      },
      fields
    });
    return (0, _utils.unflattenKnownApmEventFields)((_maybe2 = (0, _maybe4.maybe)(response.hits.hits[0])) === null || _maybe2 === void 0 ? void 0 : _maybe2.fields);
  }
  async function getTransactionMetricSample() {
    var _maybe3;
    const response = await apmEventClient.search('get_service_instance_metadata_details_application_transaction_metric', {
      apm: {
        events: [(0, _transactions.getProcessorEventForTransactions)(true)]
      },
      track_total_hits: false,
      terminate_after: 1,
      size: 1,
      query: {
        bool: {
          filter: filter.concat((0, _transactions.getBackwardCompatibleDocumentTypeFilter)(true))
        }
      },
      fields
    });
    return (0, _utils.unflattenKnownApmEventFields)((_maybe3 = (0, _maybe4.maybe)(response.hits.hits[0])) === null || _maybe3 === void 0 ? void 0 : _maybe3.fields);
  }

  // we can expect the most detail of application metrics,
  // followed by transaction events, and then finally transaction metrics
  const [applicationMetricSample, transactionEventSample, transactionMetricSample] = await Promise.all([getApplicationMetricSample(), getTransactionEventSample(), getTransactionMetricSample()]);
  const sample = (0, _lodash.merge)({}, transactionMetricSample, transactionEventSample, applicationMetricSample);
  const {
    agent,
    service,
    container,
    kubernetes,
    host,
    cloud
  } = sample;
  return {
    '@timestamp': sample['@timestamp'],
    agent,
    service,
    container,
    kubernetes,
    host,
    cloud
  };
}