"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLaunchesByLocation = getLaunchesByLocation;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _get_offset_in_ms = require("../../../common/utils/get_offset_in_ms");
var _get_bucket_size = require("../../../common/utils/get_bucket_size");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLaunchesByLocation({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end,
  locationField,
  offset
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9, _response$aggregation10, _response$aggregation11, _response$aggregation12;
  const {
    startWithOffset,
    endWithOffset
  } = (0, _get_offset_in_ms.getOffsetInMs)({
    start,
    end,
    offset
  });
  const {
    intervalString
  } = (0, _get_bucket_size.getBucketSize)({
    start: startWithOffset,
    end: endWithOffset,
    minBucketSize: 60
  });
  const aggs = {
    launches: {
      filter: {
        terms: {
          [_apm.LABEL_LIFECYCLE_STATE]: ['created', 'active']
        }
      },
      aggs: {
        byLocation: {
          terms: {
            field: locationField
          }
        }
      }
    }
  };
  const response = await apmEventClient.logEventSearch('get_mobile_location_launches', {
    track_total_hits: false,
    size: 0,
    query: {
      bool: {
        filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.rangeQuery)(startWithOffset, endWithOffset), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)]
      }
    },
    aggs: {
      timeseries: {
        date_histogram: {
          field: '@timestamp',
          fixed_interval: intervalString,
          min_doc_count: 0
        },
        aggs
      },
      ...aggs
    }
  });
  return {
    location: (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.launches) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.byLocation) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.buckets[0]) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.key,
    value: (_response$aggregation5 = (_response$aggregation6 = response.aggregations) === null || _response$aggregation6 === void 0 ? void 0 : (_response$aggregation7 = _response$aggregation6.launches) === null || _response$aggregation7 === void 0 ? void 0 : (_response$aggregation8 = _response$aggregation7.byLocation) === null || _response$aggregation8 === void 0 ? void 0 : (_response$aggregation9 = _response$aggregation8.buckets[0]) === null || _response$aggregation9 === void 0 ? void 0 : _response$aggregation9.doc_count) !== null && _response$aggregation5 !== void 0 ? _response$aggregation5 : 0,
    timeseries: (_response$aggregation10 = (_response$aggregation11 = response.aggregations) === null || _response$aggregation11 === void 0 ? void 0 : (_response$aggregation12 = _response$aggregation11.timeseries) === null || _response$aggregation12 === void 0 ? void 0 : _response$aggregation12.buckets.map(bucket => {
      var _bucket$launches$byLo, _bucket$launches, _bucket$launches$byLo2, _bucket$launches$byLo3;
      return {
        x: bucket.key,
        y: (_bucket$launches$byLo = (_bucket$launches = bucket.launches) === null || _bucket$launches === void 0 ? void 0 : (_bucket$launches$byLo2 = _bucket$launches.byLocation) === null || _bucket$launches$byLo2 === void 0 ? void 0 : (_bucket$launches$byLo3 = _bucket$launches$byLo2.buckets[0]) === null || _bucket$launches$byLo3 === void 0 ? void 0 : _bucket$launches$byLo3.doc_count) !== null && _bucket$launches$byLo !== void 0 ? _bucket$launches$byLo : 0
      };
    })) !== null && _response$aggregation10 !== void 0 ? _response$aggregation10 : []
  };
}