"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasHistoricalAgentData = hasHistoricalAgentData;
var _common = require("@kbn/observability-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function hasHistoricalAgentData(apmEventClient) {
  const hasDataInWarmOrHotDataTiers = await hasDataRequest(apmEventClient, ['data_hot', 'data_warm']);
  if (hasDataInWarmOrHotDataTiers) {
    return true;
  }
  const hasDataUnbounded = await hasDataRequest(apmEventClient);
  return hasDataUnbounded;
}
async function hasDataRequest(apmEventClient, dataTiers) {
  // the `observability:searchExcludedDataTiers` setting will also be considered
  // in the `search` function to exclude data tiers from the search
  const query = dataTiers ? {
    terms: {
      _tier: dataTiers
    }
  } : undefined;
  const params = {
    apm: {
      events: [_common.ProcessorEvent.error, _common.ProcessorEvent.metric, _common.ProcessorEvent.transaction]
    },
    terminate_after: 1,
    track_total_hits: 1,
    size: 0,
    query
  };
  const resp = await apmEventClient.search('has_historical_agent_data', params);
  return resp.hits.total.value > 0;
}