"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmErrors = getApmErrors;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _get_error_group_main_statistics = require("../../errors/get_error_groups/get_error_group_main_statistics");
var _get_downstream_dependency_name = require("./get_downstream_dependency_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmErrors(params) {
  var _datemath$parse, _datemath$parse2;
  const {
    apmEventClient,
    serviceName,
    serviceEnvironment
  } = params;
  const start = (_datemath$parse = _datemath.default.parse(params.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(params.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const res = await (0, _get_error_group_main_statistics.getErrorGroupMainStatistics)({
    serviceName,
    apmEventClient,
    environment: serviceEnvironment,
    start,
    end,
    maxNumberOfErrorGroups: 100
  });
  const promises = res.errorGroups.map(async errorGroup => {
    if (!errorGroup.traceId) {
      return {
        ...errorGroup,
        downstreamServiceResource: undefined
      };
    }
    const downstreamServiceResource = await (0, _get_downstream_dependency_name.getDownstreamServiceResource)({
      traceId: errorGroup.traceId,
      start,
      end,
      apmEventClient
    });
    return {
      ...errorGroup,
      downstreamServiceResource
    };
  });
  return Promise.all(promises);
}