"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.downstreamDependenciesRouteRt = void 0;
exports.getAssistantDownstreamDependencies = getAssistantDownstreamDependencies;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var t = _interopRequireWildcard(require("io-ts"));
var _server = require("@kbn/observability-plugin/server");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _get_destination_map = require("../../../lib/connections/get_connection_stats/get_destination_map");
var _connections = require("../../../../common/connections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const downstreamDependenciesRouteRt = exports.downstreamDependenciesRouteRt = t.intersection([t.type({
  serviceName: t.string,
  start: t.string,
  end: t.string
}), t.partial({
  serviceEnvironment: t.string
})]);
async function getAssistantDownstreamDependencies({
  arguments: args,
  apmEventClient,
  randomSampler
}) {
  var _datemath$parse, _datemath$parse2, _args$serviceEnvironm;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const {
    nodesBydependencyName: map
  } = await (0, _get_destination_map.getDestinationMap)({
    start,
    end,
    apmEventClient,
    filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, args.serviceName), ...(0, _environment_query.environmentQuery)((_args$serviceEnvironm = args.serviceEnvironment) !== null && _args$serviceEnvironm !== void 0 ? _args$serviceEnvironm : _environment_filter_values.ENVIRONMENT_ALL.value)],
    randomSampler
  });
  const items = [];
  for (const [_, node] of map) {
    if (node.type === _connections.NodeType.service) {
      items.push({
        'service.name': node.serviceName,
        // this should be set, as it's a downstream dependency, and there should be a connection
        'span.destination.service.resource': node.dependencyName
      });
    } else {
      items.push({
        'span.destination.service.resource': node.dependencyName,
        'span.type': node.spanType,
        'span.subtype': node.spanSubtype
      });
    }
  }
  return items;
}