"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useServiceMetricChartsFetcher = useServiceMetricChartsFetcher;
var _use_apm_service_context = require("../context/apm_service/use_apm_service_context");
var _use_fetcher = require("./use_fetcher");
var _use_time_range = require("./use_time_range");
var _use_apm_params = require("./use_apm_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DATA = {
  charts: []
};
function useServiceMetricChartsFetcher({
  serviceNodeName,
  kuery,
  environment
}) {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    agentName,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data = INITIAL_DATA,
    error,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end && agentName) {
      return callApmApi('GET /internal/apm/services/{serviceName}/metrics/charts', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            serviceNodeName,
            start,
            end,
            agentName
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, agentName, serviceNodeName]);
  return {
    data,
    status,
    error
  };
}