"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceAnomalyTimeseriesContext = void 0;
exports.ServiceAnomalyTimeseriesContextProvider = ServiceAnomalyTimeseriesContextProvider;
var _react = _interopRequireDefault(require("react"));
var _use_environments_context = require("../environments_context/use_environments_context");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_time_range = require("../../hooks/use_time_range");
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../apm_service/use_apm_service_context");
var _license_check = require("../../../common/license_check");
var _use_license_context = require("../license/use_license_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/service_anomaly_timeseries/service_anomaly_timeseries_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ServiceAnomalyTimeseriesContext = exports.ServiceAnomalyTimeseriesContext = /*#__PURE__*/_react.default.createContext({
  status: _use_fetcher.FETCH_STATUS.NOT_INITIATED,
  allAnomalyTimeseries: []
});
function ServiceAnomalyTimeseriesContextProvider({
  children
}) {
  var _data$allAnomalyTimes;
  const {
    serviceName,
    transactionType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const license = (0, _use_license_context.useLicenseContext)();
  const mlCapabilities = core.application.capabilities.ml;
  const canGetAnomalies = (mlCapabilities === null || mlCapabilities === void 0 ? void 0 : mlCapabilities.canGetJobs) && (0, _license_check.isActivePlatinumLicense)(license);
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    preferredEnvironment
  } = (0, _use_environments_context.useEnvironmentsContext)();
  const {
    status,
    data
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType || !canGetAnomalies) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/anomaly_charts', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          transactionType,
          environment: preferredEnvironment
        }
      }
    });
  }, [serviceName, canGetAnomalies, transactionType, start, end, preferredEnvironment]);
  return /*#__PURE__*/_react.default.createElement(ServiceAnomalyTimeseriesContext.Provider, {
    value: {
      status,
      allAnomalyTimeseries: (_data$allAnomalyTimes = data === null || data === void 0 ? void 0 : data.allAnomalyTimeseries) !== null && _data$allAnomalyTimes !== void 0 ? _data$allAnomalyTimes : []
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, children);
}