"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNonEmptySections = getNonEmptySections;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Filter out actions that shouldnt be shown and sections without any actions. */
function getNonEmptySections(sectionRecord) {
  return Object.values(sectionRecord).map(sections => sections.map(section => ({
    ...section,
    actions: section.actions.filter(action => action.condition)
  })).filter(section => !(0, _lodash.isEmpty)(section.actions))).filter(sections => !(0, _lodash.isEmpty)(sections));
}