"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDetails = CloudDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/service_icons/cloud_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CloudDetails({
  cloud,
  isServerless
}) {
  var _cloud$availabilityZo, _cloud$regions, _cloud$machineTypes;
  if (!cloud) {
    return null;
  }
  const listItems = [];
  if (cloud.provider) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.providerLabel', {
        defaultMessage: 'Cloud provider'
      }),
      description: cloud.provider
    });
  }
  if (cloud.serviceName) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.serviceNameLabel', {
        defaultMessage: 'Cloud service'
      }),
      description: cloud.serviceName
    });
  }
  if (!!((_cloud$availabilityZo = cloud.availabilityZones) !== null && _cloud$availabilityZo !== void 0 && _cloud$availabilityZo.length)) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.availabilityZoneLabel', {
        defaultMessage: '{zones, plural, =0 {Availability zone} one {Availability zone} other {Availability zones}} ',
        values: {
          zones: cloud.availabilityZones.length
        }
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 9
        }
      }, cloud.availabilityZones.map((zone, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      }, zone))))
    });
  }
  if (!!((_cloud$regions = cloud.regions) !== null && _cloud$regions !== void 0 && _cloud$regions.length)) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.regionLabel', {
        defaultMessage: '{regions, plural, =0 {Region} one {Region} other {Regions}} ',
        values: {
          regions: cloud.regions.length
        }
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 9
        }
      }, cloud.regions.map((region, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 15
        }
      }, region))))
    });
  }
  if (!!((_cloud$machineTypes = cloud.machineTypes) !== null && _cloud$machineTypes !== void 0 && _cloud$machineTypes.length)) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.machineTypesLabel', {
        defaultMessage: '{machineTypes, plural, =0{Machine type} one {Machine type} other {Machine types}} ',
        values: {
          machineTypes: cloud.machineTypes.length
        }
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 9
        }
      }, cloud.machineTypes.map((type, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      }, type))))
    });
  }
  if (cloud.projectName) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.projectIdLabel', {
        defaultMessage: 'Project ID'
      }),
      description: cloud.projectName
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: listItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 10
    }
  });
}