"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenErrorInDiscoverButton = OpenErrorInDiscoverButton;
exports.getESQLQuery = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _esqlComposer = require("@kbn/esql-composer");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _base_discover_button = require("./base_discover_button");
var _filters = require("./filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/discover_links/open_error_in_discover_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getESQLQuery = ({
  params,
  indexSettings
}) => {
  if (!indexSettings || (indexSettings === null || indexSettings === void 0 ? void 0 : indexSettings.length) === 0) {
    return null;
  }
  const {
    serviceName,
    kuery,
    errorGroupId
  } = params;
  const errorIndices = indexSettings.filter(indexSetting => ['error'].includes(indexSetting.configurationName)).map(indexSetting => {
    var _indexSetting$savedVa;
    return (_indexSetting$savedVa = indexSetting.savedValue) !== null && _indexSetting$savedVa !== void 0 ? _indexSetting$savedVa : indexSetting.defaultValue;
  });
  const dedupedIndices = Array.from(new Set(errorIndices)).join(',');
  const filters = [];
  if (errorGroupId) {
    filters.push((0, _filters.filterByErrorGroupId)(errorGroupId));
  }
  if (serviceName) {
    filters.push((0, _filters.filterByServiceName)(serviceName));
  }
  if (kuery) {
    filters.push((0, _filters.filterByKuery)(kuery));
  }
  return (0, _esqlComposer.from)(dedupedIndices).pipe(...filters).toString();
};
exports.getESQLQuery = getESQLQuery;
function OpenErrorInDiscoverButton({
  dataTestSubj
}) {
  const {
    serviceName,
    indexSettings
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      kuery
    },
    path: {
      groupId
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/errors/{groupId}', '/mobile-services/{serviceName}/errors-and-crashes/errors/{groupId}', '/mobile-services/{serviceName}/errors-and-crashes/crashes/{groupId}');
  const params = {
    kuery,
    errorGroupId: groupId,
    serviceName
  };
  const esqlQuery = getESQLQuery({
    params,
    indexSettings
  });
  return /*#__PURE__*/_react.default.createElement(_base_discover_button.BaseDiscoverButton, {
    dataTestSubj: dataTestSubj,
    esqlQuery: esqlQuery,
    rangeTo: rangeTo,
    rangeFrom: rangeFrom,
    label: _i18n.i18n.translate('xpack.apm.openErrorInDiscoverButton.label', {
      defaultMessage: 'Open in Discover'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.apm.openErrorInDiscoverButton.ariaLabel', {
      defaultMessage: 'Open in Discover'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
}