"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectWithDefaultDateRange = RedirectWithDefaultDateRange;
var _reactRouterDom = require("react-router-dom");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_date_range_redirect = require("../../../../hooks/use_date_range_redirect");
var _is_route_with_time_range = require("../../../shared/is_route_with_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is a top-level component that blocks rendering of the routes
// if there is no valid date range, and redirects to one if needed.
// If we don't do this, routes down the tree will fail because they
// expect the rangeFrom/rangeTo parameters to be set in the URL.
//
// This should be considered a temporary workaround until we have a
// more comprehensive solution for redirects that require context.

function RedirectWithDefaultDateRange({
  children
}) {
  const {
    isDateRangeSet,
    redirect
  } = (0, _use_date_range_redirect.useDateRangeRedirect)();
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const location = (0, _reactRouterDom.useLocation)();
  const matchesRoute = (0, _is_route_with_time_range.isRouteWithTimeRange)({
    apmRouter,
    location
  });
  if (!isDateRangeSet && matchesRoute) {
    redirect();
    return null;
  }
  return children;
}