"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTLSSettings = getTLSSettings;
exports.isTLSFormValid = isTLSFormValid;
var _i18n = require("@kbn/i18n");
var _utils = require("../settings_form/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TLS_ENABLED_KEY = 'tls_enabled';
function getTLSSettings() {
  return [{
    key: TLS_ENABLED_KEY,
    rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsEnabledTitle', {
      defaultMessage: 'Enable TLS'
    }),
    type: 'boolean',
    settings: [{
      key: 'tls_certificate',
      type: 'text',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsCertificateLabel', {
        defaultMessage: 'File path to server certificate'
      }),
      rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsCertificateTitle', {
        defaultMessage: 'TLS certificate'
      }),
      labelAppend: _utils.REQUIRED_LABEL,
      required: true
    }, {
      key: 'tls_key',
      type: 'text',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsKeyLabel', {
        defaultMessage: 'File path to server certificate key'
      }),
      labelAppend: _utils.REQUIRED_LABEL,
      required: true
    }, {
      key: 'tls_supported_protocols',
      type: 'combo',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsSupportedProtocolsLabel', {
        defaultMessage: 'Supported protocol versions'
      }),
      labelAppend: _utils.OPTIONAL_LABEL
    }, {
      key: 'tls_cipher_suites',
      type: 'combo',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsCipherSuitesLabel', {
        defaultMessage: 'Cipher suites for TLS connections'
      }),
      helpText: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsCipherSuitesHelpText', {
        defaultMessage: 'Not configurable for TLS 1.3.'
      }),
      labelAppend: _utils.OPTIONAL_LABEL
    }, {
      key: 'tls_curve_types',
      type: 'combo',
      label: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.tls.tlsCurveTypesLabel', {
        defaultMessage: 'Curve types for ECDHE based cipher suites'
      }),
      labelAppend: _utils.OPTIONAL_LABEL
    }]
  }];
}
function isTLSFormValid(newVars, tlsSettings) {
  // only validates TLS when its flag is enabled
  return !newVars[TLS_ENABLED_KEY].value || (0, _utils.isSettingsFormValid)(tlsSettings, newVars);
}