"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkSection = LinkSection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _documentation = require("./documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/create_edit_custom_link_flyout/link_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LinkSection({
  label,
  onChangeLabel,
  url,
  onChangeUrl
}) {
  const inputFields = [{
    name: 'label',
    label: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.label', {
      defaultMessage: 'Label'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.label.helpText', {
      defaultMessage: 'This is the label shown in the actions context menu. Keep it as short as possible.'
    }),
    placeholder: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.label.placeholder', {
      defaultMessage: 'e.g. Support tickets'
    }),
    value: label,
    onChange: onChangeLabel
  }, {
    name: 'url',
    label: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.url', {
      defaultMessage: 'URL'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.url.helpText', {
      defaultMessage: 'Add field name variables to your URL to apply values e.g. {sample}.',
      values: {
        sample: '{{trace.id}}'
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_documentation.Documentation, {
      label: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.url.doc', {
        defaultMessage: 'Learn more in the docs.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    })),
    placeholder: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.link.url.placeholder', {
      defaultMessage: 'e.g. https://www.elastic.co/'
    }),
    value: url,
    onChange: onChangeUrl
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.action.title', {
    defaultMessage: 'Link'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), inputFields.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      key: field.name,
      label: field.label,
      helpText: field.helpText,
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.required', {
        defaultMessage: 'Required'
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: field.placeholder,
      name: field.name,
      fullWidth: true,
      value: field.value,
      onChange: e => field.onChange(e.target.value),
      "data-test-subj": field.name,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }));
  }));
}