"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentContextualInformation = AgentContextualInformation;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_default_time_range = require("../../../../../../hooks/use_default_time_range");
var _service_link = require("../../../../../shared/links/apm/service_link");
var _sticky_properties = require("../../../../../shared/sticky_properties");
var _get_comparison_enabled = require("../../../../../shared/time_comparison/get_comparison_enabled");
var _truncate_with_tooltip = require("../../../../../shared/truncate_with_tooltip");
var _agent_explorer_docs_link = require("../../agent_explorer_docs_link");
var _agent_latest_version = require("../../agent_latest_version");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_explorer/agent_instances/agent_contextual_information/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const serviceLabel = _i18n.i18n.translate('xpack.apm.agentInstancesDetails.serviceLabel', {
  defaultMessage: 'Service'
});
const agentNameLabel = _i18n.i18n.translate('xpack.apm.agentInstancesDetails.agentNameLabel', {
  defaultMessage: 'Agent Name'
});
const instancesLabel = _i18n.i18n.translate('xpack.apm.agentInstancesDetails.intancesLabel', {
  defaultMessage: 'Instances'
});
const latestVersionLabel = _i18n.i18n.translate('xpack.apm.agentInstancesDetails.latestVersionLabel', {
  defaultMessage: 'Latest agent version'
});
const agentDocsLabel = _i18n.i18n.translate('xpack.apm.agentInstancesDetails.agentDocsUrlLabel', {
  defaultMessage: 'Agent documentation'
});
function AgentContextualInformation({
  agentName,
  serviceName,
  agentDocsPageUrl,
  instances,
  latestVersion,
  query,
  isLatestVersionsLoading,
  latestVersionsFailed
}) {
  const {
    core,
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const latestAgentVersionEnabled = !(0, _lodash.isEmpty)(config.latestAgentVersionsUrl);
  const comparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core
  });
  const {
    rangeFrom,
    rangeTo
  } = (0, _use_default_time_range.useDefaultTimeRange)();
  const width = latestAgentVersionEnabled ? '20%' : '25%';
  const stickyProperties = [{
    label: serviceLabel,
    fieldName: serviceLabel,
    val: /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmAgentExplorerListServiceLink",
      text: serviceName,
      content: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
        agentName: agentName,
        query: {
          kuery: query.kuery,
          serviceGroup: '',
          rangeFrom,
          rangeTo,
          environment: query.environment,
          comparisonEnabled
        },
        serviceName: serviceName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }),
    width
  }, {
    label: agentNameLabel,
    fieldName: agentNameLabel,
    val: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }, agentName))),
    width
  }, {
    label: instancesLabel,
    fieldName: instancesLabel,
    val: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 13
      }
    }, instances))),
    width
  }, ...(latestAgentVersionEnabled ? [{
    label: latestVersionLabel,
    fieldName: latestVersionLabel,
    val: /*#__PURE__*/_react.default.createElement(_agent_latest_version.AgentLatestVersion, {
      agentName: agentName,
      isLoading: isLatestVersionsLoading,
      latestVersion: latestVersion,
      failed: latestVersionsFailed,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 15
      }
    }),
    width
  }] : []), {
    label: agentDocsLabel,
    fieldName: agentDocsLabel,
    val: /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmAgentExplorerListDocsLink",
      text: `${agentName} agent docs`,
      content: /*#__PURE__*/_react.default.createElement(_agent_explorer_docs_link.AgentExplorerDocsLink, {
        agentName: agentName,
        repositoryUrl: agentDocsPageUrl,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 20
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }),
    width
  }];
  return /*#__PURE__*/_react.default.createElement(_sticky_properties.StickyProperties, {
    stickyProperties: stickyProperties,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 10
    }
  });
}