"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedConfigValueInput = AdvancedConfigValueInput;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/settings_page/advanced_config_value_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AdvancedConfigValueInput({
  configValue,
  configKey,
  id,
  showLabel,
  revalidate,
  onChange,
  onDelete,
  addValidationError,
  removeValidationError
}) {
  const [touched, setTouched] = (0, _react.useState)(false);
  const isInvalidInput = value => {
    return value === '';
  };
  const isFormInvalid = (0, _react.useMemo)(() => {
    return (touched || revalidate) && isInvalidInput(configValue);
  }, [touched, configValue, revalidate]);
  const handleValueChange = value => {
    setTouched(true);
    onChange({
      key: configKey,
      value
    });
  };
  (0, _react.useEffect)(() => {
    const errorId = `value${id}`;
    if (isInvalidInput(configValue)) {
      addValidationError(errorId, touched);
    } else {
      removeValidationError(errorId);
    }
  }, [configValue, id, touched, addValidationError, removeValidationError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: showLabel ? _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.valueLabel', {
      defaultMessage: 'value'
    }) : undefined,
    error: _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.valueEmptyError', {
      defaultMessage: 'Value cannot be empty'
    }),
    isInvalid: isFormInvalid,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isFormInvalid,
    "data-test-subj": "apmSettingsAdvancedConfigurationValueField",
    "aria-label": _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.valueAriaLabel', {
      defaultMessage: 'Advanced configuration value'
    }),
    fullWidth: true,
    value: configValue,
    onChange: e => handleValueChange(e.target.value),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmSettingsRemoveAdvancedConfigurationButton",
      "aria-label": _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.removeButtonAriaLabel', {
        defaultMessage: 'Remove advanced configuration'
      }),
      iconType: "trash",
      color: 'danger',
      onClick: () => onDelete(configKey, id),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }));
}