"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.popoverWidth = exports.getNodeHeight = exports.getCytoscapeOptions = exports.getCytoscapeDivStyle = exports.getAnimationOptions = void 0;
var _apm = require("../../../../common/es_fields/apm");
var _service_health_status = require("../../../../common/service_health_status");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _icons = require("./icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const popoverWidth = exports.popoverWidth = 350;
function getServiceAnomalyStats(el) {
  const serviceAnomalyStats = el.data('serviceAnomalyStats');
  return serviceAnomalyStats;
}
function getBorderColorFn(euiTheme) {
  return el => {
    const hasAnomalyDetectionJob = el.data('serviceAnomalyStats') !== undefined;
    const anomalyStats = getServiceAnomalyStats(el);
    if (hasAnomalyDetectionJob) {
      var _anomalyStats$healthS;
      return (0, _service_health_status.getServiceHealthStatusColor)(euiTheme, (_anomalyStats$healthS = anomalyStats === null || anomalyStats === void 0 ? void 0 : anomalyStats.healthStatus) !== null && _anomalyStats$healthS !== void 0 ? _anomalyStats$healthS : _service_health_status.ServiceHealthStatus.unknown);
    }
    if (el.hasClass('primary') || el.selected()) {
      return euiTheme.colors.primary;
    }
    return euiTheme.colors.mediumShade;
  };
}
const getBorderStyle = el => {
  var _getServiceAnomalySta;
  const status = (_getServiceAnomalySta = getServiceAnomalyStats(el)) === null || _getServiceAnomalySta === void 0 ? void 0 : _getServiceAnomalySta.healthStatus;
  if (status === _service_health_status.ServiceHealthStatus.critical) {
    return 'double';
  } else {
    return 'solid';
  }
};
function getBorderWidth(el) {
  var _getServiceAnomalySta2;
  const status = (_getServiceAnomalySta2 = getServiceAnomalyStats(el)) === null || _getServiceAnomalySta2 === void 0 ? void 0 : _getServiceAnomalySta2.healthStatus;
  if (status === _service_health_status.ServiceHealthStatus.warning) {
    return 4;
  } else if (status === _service_health_status.ServiceHealthStatus.critical) {
    return 8;
  } else {
    return 4;
  }
}

// IE 11 does not properly load some SVGs or draw certain shapes. This causes
// a runtime error and the map fails work at all. We would prefer to do some
// kind of feature detection rather than browser detection, but some of these
// limitations are not well documented for older browsers.
//
// This method of detecting IE is from a Stack Overflow answer:
// https://stackoverflow.com/a/21825207
//
// @ts-expect-error `documentMode` is not recognized as a valid property of `document`.
const isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
const getAnimationOptions = euiTheme => ({
  duration: euiTheme.animation.normal ? parseInt(euiTheme.animation.normal, 10) : 0,
  // @ts-expect-error The cubic-bezier options here are not recognized by the cytoscape types
  easing: euiTheme.animation.bounce
});
exports.getAnimationOptions = getAnimationOptions;
const zIndexNode = 200;
const zIndexEdge = 100;
const zIndexEdgeHighlight = 110;
const zIndexEdgeHover = 120;
const getNodeHeight = euiTheme => parseInt(euiTheme.size.xxl, 10);
exports.getNodeHeight = getNodeHeight;
function isService(el) {
  return el.data(_apm.SERVICE_NAME) !== undefined;
}
const getStyle = euiTheme => {
  const lineColor = euiTheme.colors.mediumShade;
  return [{
    selector: 'core',
    // @ts-expect-error DefinitelyTyped does not recognize 'active-bg-opacity'
    style: {
      'active-bg-opacity': 0
    }
  }, {
    selector: 'node',
    style: {
      'background-color': euiTheme.colors.backgroundBasePlain,
      // The DefinitelyTyped definitions don't specify that a function can be
      // used here.
      'background-image': el => (0, _icons.iconForNode)(el),
      'background-height': el => isService(el) ? '60%' : '40%',
      'background-width': el => isService(el) ? '60%' : '40%',
      'border-color': getBorderColorFn(euiTheme),
      'border-style': getBorderStyle,
      'border-width': getBorderWidth,
      color: el => el.hasClass('primary') || el.selected() ? euiTheme.colors.textPrimary : euiTheme.colors.textParagraph,
      // theme.euiFontFamily doesn't work here for some reason, so we're just
      // specifying a subset of the fonts for the label text.
      'font-family': 'Inter UI, Segoe UI, Helvetica, Arial, sans-serif',
      'font-size': euiTheme.size.s,
      ghost: 'yes',
      'ghost-offset-x': 0,
      'ghost-offset-y': 2,
      'ghost-opacity': 0.15,
      height: getNodeHeight(euiTheme),
      label: el => isService(el) ? el.data(_apm.SERVICE_NAME) : el.data('label') || el.data(_apm.SPAN_DESTINATION_SERVICE_RESOURCE),
      'min-zoomed-font-size': parseInt(euiTheme.size.s, 10),
      'overlay-opacity': 0,
      shape: el => isService(el) ? isIE11 ? 'rectangle' : 'ellipse' : 'diamond',
      'text-background-color': euiTheme.colors.primary,
      'text-background-opacity': el => el.hasClass('primary') || el.selected() ? 0.1 : 0,
      'text-background-padding': euiTheme.size.xs,
      'text-background-shape': 'roundrectangle',
      'text-margin-y': parseInt(euiTheme.size.s, 10),
      'text-max-width': '200px',
      'text-valign': 'bottom',
      'text-wrap': 'ellipsis',
      width: euiTheme.size.xxl,
      'z-index': zIndexNode
    }
  }, {
    selector: 'edge',
    style: {
      'curve-style': 'unbundled-bezier',
      'line-color': lineColor,
      'overlay-opacity': 0,
      'target-arrow-color': lineColor,
      'target-arrow-shape': isIE11 ? 'none' : 'triangle',
      // The DefinitelyTyped definitions don't specify this property since it's
      // fairly new.
      //
      // @ts-expect-error
      'target-distance-from-node': isIE11 ? undefined : euiTheme.size.xs,
      width: 1,
      'source-arrow-shape': 'none',
      'z-index': zIndexEdge
    }
  }, {
    selector: 'edge[bidirectional]',
    style: {
      'source-arrow-shape': isIE11 ? 'none' : 'triangle',
      'source-arrow-color': lineColor,
      'target-arrow-shape': isIE11 ? 'none' : 'triangle',
      'source-distance-from-node': isIE11 ? undefined : parseInt(euiTheme.size.xs, 10),
      'target-distance-from-node': isIE11 ? undefined : parseInt(euiTheme.size.xs, 10)
    }
  }, {
    selector: 'edge[isInverseEdge]',
    style: {
      visibility: 'hidden'
    }
  }, {
    selector: 'edge.nodeHover',
    style: {
      width: 4,
      'z-index': zIndexEdgeHover,
      'line-color': euiTheme.colors.darkShade,
      'source-arrow-color': euiTheme.colors.darkShade,
      'target-arrow-color': euiTheme.colors.darkShade
    }
  }, {
    selector: 'node.hover',
    style: {
      'border-width': getBorderWidth
    }
  }, {
    selector: 'edge.highlight',
    style: {
      width: 4,
      'line-color': euiTheme.colors.primary,
      'source-arrow-color': euiTheme.colors.primary,
      'target-arrow-color': euiTheme.colors.primary,
      'z-index': zIndexEdgeHighlight
    }
  }];
};

// The CSS styles for the div containing the cytoscape element. Makes a
// background grid of dots.
const getCytoscapeDivStyle = (euiTheme, status) => ({
  background: `linear-gradient(
  90deg,
  ${euiTheme.colors.backgroundBasePlain}
    calc(${euiTheme.size.l} - calc(${euiTheme.size.xs} / 2)),
  transparent 1%
)
center,
linear-gradient(
  ${euiTheme.colors.backgroundBasePlain}
    calc(${euiTheme.size.l} - calc(${euiTheme.size.xs} / 2)),
  transparent 1%
)
center,
${euiTheme.colors.lightShade}`,
  backgroundSize: `${euiTheme.size.l} ${euiTheme.size.l}`,
  cursor: `${status === _use_fetcher.FETCH_STATUS.LOADING ? 'wait' : 'grab'}`,
  marginTop: 0
});
exports.getCytoscapeDivStyle = getCytoscapeDivStyle;
const getCytoscapeOptions = euiTheme => ({
  boxSelectionEnabled: false,
  maxZoom: 3,
  minZoom: 0.2,
  style: getStyle(euiTheme)
});
exports.getCytoscapeOptions = getCytoscapeOptions;