"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TracesInDiscoverCallout = TracesInDiscoverCallout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _esqlComposer = require("@kbn/esql-composer");
var _apmTypes = require("@kbn/apm-types");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_local_storage = require("../../../../hooks/use_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_inventory/traces_in_discover_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buttonLabel = _i18n.i18n.translate('xpack.apm.apmMainTemplate.euiCallout.buttonLabel', {
  defaultMessage: 'View traces in Discover'
});
const calloutTitle = _i18n.i18n.translate('xpack.apm.apmMainTemplate.euiCallout.title', {
  defaultMessage: 'Try the new traces experience in Discover'
});
const calloutContent = _i18n.i18n.translate('xpack.apm.apmMainTemplate.euiCallout.content', {
  defaultMessage: 'Now you can view and analyse the full-screen waterfall and explore your trace data in context.'
});
const tracesInDiscoverCalloutStorageKey = 'apm.tracesInDiscoverCalloutDismissed';
function useTracesIndex(apmSourcesAccess) {
  const {
    data
  } = (0, _public2.useFetcher)(() => {
    if (!apmSourcesAccess) return;
    return apmSourcesAccess.getApmIndices();
  }, [apmSourcesAccess]);
  return data ? Array.from(new Set([data.span, data.transaction])).join(',') : undefined;
}
function getEsqlQuery(environment, tracesIndex) {
  const base = (0, _esqlComposer.from)(tracesIndex);
  if (environment === _environment_filter_values.ENVIRONMENT_ALL_VALUE) {
    return base.toString();
  }
  if (environment === _environment_filter_values.ENVIRONMENT_NOT_DEFINED_VALUE) {
    return base.pipe((0, _esqlComposer.where)(`${_apmTypes.SERVICE_ENVIRONMENT} IS NULL`)).toString();
  }
  return base.pipe((0, _esqlComposer.where)(`${_apmTypes.SERVICE_ENVIRONMENT} == ?serviceEnvironment`, {
    serviceEnvironment: environment
  })).toString();
}
function TracesInDiscoverCallout() {
  const {
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    space
  } = (0, _public2.useKibanaSpace)();
  const {
    services: {
      apmSourcesAccess
    }
  } = (0, _public.useKibana)();
  const tracesIndex = useTracesIndex(apmSourcesAccess);
  const {
    query: {
      environment,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/service-map');
  const [dismissedCallout, setDismissedCallout] = (0, _use_local_storage.useLocalStorage)(tracesInDiscoverCalloutStorageKey, false);
  const obltSolutionId = 'oblt';
  const discoverHref = (0, _react.useMemo)(() => {
    var _share$url$locators$g;
    if (!tracesIndex) return undefined;
    return (_share$url$locators$g = share.url.locators.get(_deeplinksAnalytics.DISCOVER_APP_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getRedirectUrl({
      timeRange: {
        from: rangeFrom,
        to: rangeTo
      },
      query: {
        esql: getEsqlQuery(environment, tracesIndex)
      }
    });
  }, [share.url.locators, tracesIndex, environment, rangeFrom, rangeTo]);
  if (dismissedCallout || !discoverHref || (space === null || space === void 0 ? void 0 : space.solution) !== obltSolutionId) {
    return null;
  }
  function dismissCallout() {
    setDismissedCallout(true);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "apmServiceInventoryTracesInDiscoverCallout",
    size: "m",
    announceOnMount: true,
    title: calloutTitle,
    iconType: "cheer",
    onDismiss: dismissCallout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, calloutContent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmServiceInventoryTracesInDiscoverCalloutButton",
    fill: true,
    href: discoverHref,
    "aria-label": buttonLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, buttonLabel));
}