"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeVariables = exports.nodeLineNumbers = exports.nodeHighlightLang = exports.node = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeVariables = secretToken => ({
  ...(secretToken && {
    secretToken: 'secretToken'
  }),
  ...(!secretToken && {
    apiKey: 'apiKey'
  }),
  apmServerUrl: 'serverUrl'
});
exports.nodeVariables = nodeVariables;
const nodeHighlightLang = exports.nodeHighlightLang = 'js';
const nodeLineNumbers = () => ({
  start: 1,
  highlight: '2, 4, 7, 10, 13-14'
});
exports.nodeLineNumbers = nodeLineNumbers;
const node = exports.node = `// ${_i18n.i18n.translate('xpack.apm.onboarding.nodeClient.configure.commands.addThisToTheFileTopComment', {
  defaultMessage: 'Add this to the very top of the first file loaded in your app'
})}
var apm = require('elastic-apm-node').start({
  // {{serviceNameHint}} ${_i18n.i18n.translate('xpack.apm.onboarding.nodeClient.createConfig.commands.serviceName', {
  defaultMessage: 'Overrides the service name in package.json.'
})}
  serviceName: '<your-service-name>',

  {{^secretToken}}
  // {{apiKeyHint}}
  apiKey: '{{{apiKey}}}',
  {{/secretToken}}
  {{#secretToken}}
  // {{secretTokenHint}}
  secretToken: '{{{secretToken}}}',
  {{/secretToken}}

  // {{{serverUrlHint}}}
  serverUrl: '{{{apmServerUrl}}}',

  // {{{serviceEnvironmentHint}}}
  environment: '<your-environment>'
})`;