"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorDistribution = ErrorDistribution;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _timeseries_chart_with_context = require("../../../../../shared/charts/timeseries_chart_with_context");
var _use_url_params = require("../../../../../../context/url_params_context/use_url_params");
var _use_fetcher = require("../../../../../../hooks/use_fetcher");
var _use_previous_period_text = require("../../../../../../hooks/use_previous_period_text");
var _get_comparison_chart_theme = require("../../../../../shared/time_comparison/get_comparison_chart_theme");
var _get_timeseries_color = require("../../../../../shared/charts/helper/get_timeseries_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/errors_and_crashes_group_details/shared/distribution/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorDistribution({
  distribution,
  title,
  tip,
  height,
  fetchStatus
}) {
  var _distribution$current, _distribution$previou;
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    comparisonEnabled
  } = urlParams;
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const {
    currentPeriodColor,
    previousPeriodColor
  } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.ERROR_OCCURRENCES);
  const timeseries = [{
    data: (_distribution$current = distribution === null || distribution === void 0 ? void 0 : distribution.currentPeriod) !== null && _distribution$current !== void 0 ? _distribution$current : [],
    type: 'linemark',
    color: currentPeriodColor,
    title
  }, ...(comparisonEnabled ? [{
    data: (_distribution$previou = distribution === null || distribution === void 0 ? void 0 : distribution.previousPeriod) !== null && _distribution$previou !== void 0 ? _distribution$previou : [],
    type: 'area',
    color: previousPeriodColor,
    title: previousPeriodLabel
  }] : [])];
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    style: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, (0, _use_fetcher.isPending)(fetchStatus) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 34
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tip,
    position: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    id: title,
    height: height,
    showAnnotations: false,
    fetchStatus: fetchStatus,
    yLabelFormat: value => `${value}`,
    timeseries: timeseries,
    customTheme: comparisonChartTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }));
}