"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessActiveInstances = ServerlessActiveInstances;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _timeseries_chart_with_context = require("../../../shared/charts/timeseries_chart_with_context");
var _list_metric = require("../../../shared/list_metric");
var _serverless_function_name_link = require("./serverless_function_name_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics/serverless_metrics/serverless_active_instances.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const palette = (0, _eui.euiPaletteColorBlind)({
  rotations: 2
});
function ServerlessActiveInstances({
  serverlessId
}) {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data = {
      activeInstances: [],
      timeseries: []
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return undefined;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/metrics/serverless/active_instances', {
      params: {
        path: {
          serviceName
        },
        query: {
          kuery,
          environment,
          start,
          end,
          serverlessId
        }
      }
    });
  }, [kuery, environment, serviceName, start, end, serverlessId]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const columns = [{
    field: 'serverlessFunctionName',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.functionName', {
      defaultMessage: 'Function name'
    }),
    sortable: true,
    truncateText: true,
    render: (_, item) => {
      return /*#__PURE__*/_react.default.createElement(_serverless_function_name_link.ServerlessFunctionNameLink, {
        serverlessFunctionName: item.serverlessFunctionName,
        serverlessId: item.serverlessId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'activeInstanceName',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.name', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    field: 'serverlessDurationAvg',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.functionDuration', {
      defaultMessage: 'Function duration'
    }),
    sortable: true,
    render: (_, {
      serverlessDurationAvg,
      timeseries
    }) => {
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: isLoading,
        series: timeseries.serverlessDuration,
        color: palette[1],
        valueLabel: (0, _formatters.asMillisecondDuration)(serverlessDurationAvg),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'billedDurationAvg',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.billedDuration', {
      defaultMessage: 'Billed duration'
    }),
    sortable: true,
    render: (_, {
      billedDurationAvg,
      timeseries
    }) => {
      return /*#__PURE__*/_react.default.createElement(_list_metric.ListMetric, {
        isLoading: isLoading,
        series: timeseries.billedDuration,
        color: palette[2],
        valueLabel: (0, _formatters.asMillisecondDuration)(billedDurationAvg),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'avgMemoryUsed',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.memoryUsageAvg', {
      defaultMessage: 'Memory usage avg.'
    }),
    sortable: true,
    render: (_, {
      avgMemoryUsed
    }) => {
      return (0, _formatters.asDynamicBytes)(avgMemoryUsed);
    }
  }, {
    field: 'memorySize',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.memorySize', {
      defaultMessage: 'Memory size'
    }),
    sortable: true,
    render: (_, {
      memorySize
    }) => {
      return (0, _formatters.asDynamicBytes)(memorySize);
    }
  }];
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'serverlessDurationAvg',
      direction: 'desc'
    }
  }), []);
  const charts = (0, _react.useMemo)(() => [{
    title: _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.title', {
      defaultMessage: 'Active instances'
    }),
    data: data.timeseries,
    type: 'bar',
    color: palette[2]
  }], [data.timeseries]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serverlessMetrics.activeInstances.title', {
    defaultMessage: 'Active instances'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    timeseries: charts,
    id: "activeInstances",
    fetchStatus: status,
    yLabelFormat: _formatters.asInteger,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoading,
    items: data.activeInstances,
    columns: columns,
    pagination: {
      showPerPageOptions: false,
      pageSize: 5
    },
    sorting: sorting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }))));
}