"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionDistributionChartData = getTransactionDistributionChartData;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTransactionDistributionChartData({
  euiTheme,
  allTransactionsHistogram,
  failedTransactionsHistogram,
  selectedTerm
}) {
  const transactionDistributionChartData = [];
  if (Array.isArray(allTransactionsHistogram)) {
    transactionDistributionChartData.push({
      id: _i18n.i18n.translate('xpack.apm.transactionDistribution.chart.allTransactionsLabel', {
        defaultMessage: 'All transactions'
      }),
      histogram: allTransactionsHistogram,
      areaSeriesColor: euiTheme.colors.vis.euiColorVis1
    });
  }
  if (Array.isArray(failedTransactionsHistogram)) {
    transactionDistributionChartData.push({
      id: _i18n.i18n.translate('xpack.apm.transactionDistribution.chart.failedTransactionsLabel', {
        defaultMessage: 'Failed transactions'
      }),
      histogram: failedTransactionsHistogram,
      areaSeriesColor: euiTheme.colors.vis.euiColorVis7
    });
  }
  if (selectedTerm && Array.isArray(selectedTerm.histogram)) {
    transactionDistributionChartData.push({
      id: `${selectedTerm.fieldName}:${selectedTerm.fieldValue}`,
      histogram: selectedTerm.histogram,
      areaSeriesColor: euiTheme.colors.vis.euiColorVis2
    });
  }
  return transactionDistributionChartData;
}