"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerApmRuleTypes = registerApmRuleTypes;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _formatters = require("../../../../common/utils/formatters");
var _default_action_message = require("../../../../common/rules/default_action_message");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// copied from elasticsearch_fieldnames.ts to limit page load bundle size
const SERVICE_ENVIRONMENT = 'service.environment';
const SERVICE_NAME = 'service.name';
const TRANSACTION_TYPE = 'transaction.type';
function registerApmRuleTypes(observabilityRuleTypeRegistry) {
  observabilityRuleTypeRegistry.register({
    id: _ruleDataUtils.ApmRuleType.ErrorCount,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.errorCount.description', {
      defaultMessage: 'Alert when the number of errors in a service exceeds a defined threshold.'
    }),
    format: ({
      fields
    }) => {
      return {
        reason: fields[_ruleDataUtils.ALERT_REASON],
        link: (0, _formatters.getAlertUrlErrorCount)(
        // TODO:fix SERVICE_NAME when we move it to initializeIndex
        String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]))
      };
    },
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRulesErrorCount}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./error_count_rule_type')))),
    validate: () => ({
      errors: []
    }),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.errorCountMessage,
    defaultRecoveryMessage: _default_action_message.errorCountRecoveryMessage,
    priority: 80
  });
  observabilityRuleTypeRegistry.register({
    id: _ruleDataUtils.ApmRuleType.TransactionDuration,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.transactionDuration.description', {
      defaultMessage: 'Alert when the latency of a specific transaction type in a service exceeds a defined threshold.'
    }),
    format: ({
      fields
    }) => {
      return {
        reason: fields[_ruleDataUtils.ALERT_REASON],
        link: (0, _formatters.getAlertUrlTransaction)(
        // TODO:fix SERVICE_NAME when we move it to initializeIndex
        String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]), String(fields[TRANSACTION_TYPE][0]))
      };
    },
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRulesTransactionDuration}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./transaction_duration_rule_type')))),
    validate: () => ({
      errors: []
    }),
    alertDetailsAppSection: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../ui_components/alert_details_app_section')))),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.transactionDurationMessage,
    defaultRecoveryMessage: _default_action_message.transactionDurationRecoveryMessage,
    priority: 60
  });
  observabilityRuleTypeRegistry.register({
    id: _ruleDataUtils.ApmRuleType.TransactionErrorRate,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.transactionErrorRate.description', {
      defaultMessage: 'Alert when the rate of transaction errors in a service exceeds a defined threshold.'
    }),
    format: ({
      fields
    }) => ({
      reason: fields[_ruleDataUtils.ALERT_REASON],
      link: (0, _formatters.getAlertUrlTransaction)(
      // TODO:fix SERVICE_NAME when we move it to initializeIndex
      String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]), String(fields[TRANSACTION_TYPE][0]))
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRulesTransactionError}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./transaction_error_rate_rule_type')))),
    validate: () => ({
      errors: []
    }),
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.transactionErrorRateMessage,
    defaultRecoveryMessage: _default_action_message.transactionErrorRateRecoveryMessage,
    priority: 70
  });
  observabilityRuleTypeRegistry.register({
    id: _ruleDataUtils.ApmRuleType.Anomaly,
    description: _i18n.i18n.translate('xpack.apm.alertTypes.anomaly.description', {
      defaultMessage: 'Alert when either the latency, throughput, or failed transaction rate of a service is anomalous.'
    }),
    format: ({
      fields
    }) => ({
      reason: fields[_ruleDataUtils.ALERT_REASON],
      link: (0, _formatters.getAlertUrlTransaction)(
      // TODO:fix SERVICE_NAME when we move it to initializeIndex
      String(fields[SERVICE_NAME][0]), fields[SERVICE_ENVIRONMENT] && String(fields[SERVICE_ENVIRONMENT][0]), String(fields[TRANSACTION_TYPE][0]))
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.alerting.apmRulesAnomaly}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_rule_type')))),
    validate: validateAnomalyRule,
    requiresAppContext: false,
    defaultActionMessage: _default_action_message.anomalyMessage,
    defaultRecoveryMessage: _default_action_message.anomalyRecoveryMessage,
    priority: 90
  });
}
function validateAnomalyRule(ruleParams) {
  const validationResult = {
    errors: {}
  };
  const errors = {};
  validationResult.errors = errors;
  if (ruleParams.anomalyDetectorTypes && ruleParams.anomalyDetectorTypes.length < 1) {
    errors.anomalyDetectorTypes = _i18n.i18n.translate('xpack.apm.validateAnomalyRule.', {
      defaultMessage: 'At least one detector type is required'
    });
  }
  return validationResult;
}