"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.joinByKey = joinByKey;
var _lodash = require("lodash");
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Joins a list of records by a given key. Key can be any type of value, from
 * strings to plain objects, as long as it is present in all records. `isEqual`
 * is used for comparing keys.
 *
 * UnionToIntersection is needed to get all keys of union types, see below for
 * example.
 *
 const agentNames = [{ serviceName: '', agentName: '' }];
 const transactionRates = [{ serviceName: '', transactionsPerMinute: 1 }];
 const flattened = joinByKey(
  [...agentNames, ...transactionRates],
  'serviceName'
 );
*/

function joinByKey(items, key, mergeFn = (a, b) => (0, _lodash.merge)({}, a, b)) {
  const keys = (0, _lodash.castArray)(key);
  // Create a map to quickly query the key of group.
  const map = new Map();
  items.forEach(current => {
    // The key of the map is a stable JSON string of the values from given keys.
    // We need stable JSON string to support plain object values.
    const stableKey = (0, _jsonStableStringify.default)(keys.map(k => current[k]));
    if (map.has(stableKey)) {
      const item = map.get(stableKey);
      // delete and set the key to put it last
      map.delete(stableKey);
      map.set(stableKey, mergeFn(item, current));
    } else {
      map.set(stableKey, {
        ...current
      });
    }
  });
  return [...map.values()];
}