"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseCountIgnoreRuleTypeBucket = parseCountIgnoreRuleTypeBucket;
var _replace_dots_with_underscores = require("./replace_dots_with_underscores");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseCountIgnoreRuleTypeBucket(ruleTypeBuckets) {
  const buckets = ruleTypeBuckets;
  return (buckets !== null && buckets !== void 0 ? buckets : []).reduce((acc, bucket) => {
    var _bucket$ignored_field, _bucket$ignored_field2;
    const ruleType = (0, _replace_dots_with_underscores.replaceDotSymbols)(`${bucket.key}`);
    acc[ruleType] = (_bucket$ignored_field = (_bucket$ignored_field2 = bucket.ignored_field.buckets) === null || _bucket$ignored_field2 === void 0 ? void 0 : _bucket$ignored_field2.length) !== null && _bucket$ignored_field !== void 0 ? _bucket$ignored_field : 0;
    return acc;
  }, {});
}