"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertState = getAlertState;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _alert_task_instance = require("../../task_runner/alert_task_instance");
var _authorization = require("../../authorization");
var _get_rule = require("../../application/rule/methods/get/get_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAlertState(context, {
  id
}) {
  const rule = await (0, _get_rule.getRule)(context, {
    id
  });
  await context.authorization.ensureAuthorized({
    ruleTypeId: rule.alertTypeId,
    consumer: rule.consumer,
    operation: _authorization.ReadOperations.GetRuleState,
    entity: _authorization.AlertingAuthorizationEntity.Rule
  });
  if (rule.scheduledTaskId) {
    try {
      const {
        state
      } = (0, _alert_task_instance.taskInstanceToAlertTaskInstance)(await context.taskManager.get(rule.scheduledTaskId), rule);
      return state;
    } catch (e) {
      if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        context.logger.warn(`Task (${rule.scheduledTaskId}) not found`);
      } else {
        context.logger.warn(`An error occurred when getting the task state for (${rule.scheduledTaskId}): ${e.message}`);
      }
    }
  }
}