"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAndAuthorizeSystemActions = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _get_system_action_kibana_privileges = require("../connector_adapters/get_system_action_kibana_privileges");
var _validate_rule_action_params = require("../connector_adapters/validate_rule_action_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateAndAuthorizeSystemActions = async ({
  actionsClient,
  connectorAdapterRegistry,
  actionsAuthorization,
  rule,
  systemActions = []
}) => {
  if (systemActions.length === 0) {
    return;
  }

  /**
   * When updating or creating a rule the actions may not contain
   * the actionTypeId. We need to getBulk using the
   * actionsClient to get the actionTypeId of each action.
   * The actionTypeId is needed to get the schema of
   * the action params using the connector adapter registry
   */
  const actionIds = new Set(systemActions.map(action => action.id));
  if (actionIds.size !== systemActions.length) {
    throw _boom.default.badRequest('Cannot use the same system action twice');
  }
  const actionResults = await actionsClient.getBulk({
    ids: Array.from(actionIds),
    throwIfSystemAction: false
  });
  const systemActionsWithActionTypeId = [];
  for (const systemAction of systemActions) {
    const isSystemAction = actionsClient.isSystemAction(systemAction.id);
    const foundAction = actionResults.find(actionRes => actionRes.id === systemAction.id);
    if (!isSystemAction || !foundAction) {
      throw _boom.default.badRequest(`Action ${systemAction.id} is not a system action`);
    }
    systemActionsWithActionTypeId.push({
      ...systemAction,
      actionTypeId: foundAction.actionTypeId
    });
  }
  (0, _validate_rule_action_params.bulkValidateConnectorAdapterActionParams)({
    connectorAdapterRegistry,
    actions: systemActionsWithActionTypeId
  });
  const additionalPrivileges = (0, _get_system_action_kibana_privileges.getSystemActionKibanaPrivileges)({
    connectorAdapterRegistry,
    systemActions: systemActionsWithActionTypeId,
    rule: {
      consumer: rule.consumer,
      producer: rule.producer
    }
  });
  await actionsAuthorization.ensureAuthorized({
    operation: 'execute',
    additionalPrivileges
  });
};
exports.validateAndAuthorizeSystemActions = validateAndAuthorizeSystemActions;